/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ecr.AmazonECRAsync;
import com.amazonaws.services.ecr.AmazonECRAsyncClientBuilder;
import com.amazonaws.services.ecr.AmazonECRClient;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityResult;
import com.amazonaws.services.ecr.model.BatchDeleteImageRequest;
import com.amazonaws.services.ecr.model.BatchDeleteImageResult;
import com.amazonaws.services.ecr.model.BatchGetImageRequest;
import com.amazonaws.services.ecr.model.BatchGetImageResult;
import com.amazonaws.services.ecr.model.BatchGetRepositoryScanningConfigurationRequest;
import com.amazonaws.services.ecr.model.BatchGetRepositoryScanningConfigurationResult;
import com.amazonaws.services.ecr.model.CompleteLayerUploadRequest;
import com.amazonaws.services.ecr.model.CompleteLayerUploadResult;
import com.amazonaws.services.ecr.model.CreatePullThroughCacheRuleRequest;
import com.amazonaws.services.ecr.model.CreatePullThroughCacheRuleResult;
import com.amazonaws.services.ecr.model.CreateRepositoryRequest;
import com.amazonaws.services.ecr.model.CreateRepositoryResult;
import com.amazonaws.services.ecr.model.DeleteLifecyclePolicyRequest;
import com.amazonaws.services.ecr.model.DeleteLifecyclePolicyResult;
import com.amazonaws.services.ecr.model.DeletePullThroughCacheRuleRequest;
import com.amazonaws.services.ecr.model.DeletePullThroughCacheRuleResult;
import com.amazonaws.services.ecr.model.DeleteRegistryPolicyRequest;
import com.amazonaws.services.ecr.model.DeleteRegistryPolicyResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryResult;
import com.amazonaws.services.ecr.model.DescribeImageReplicationStatusRequest;
import com.amazonaws.services.ecr.model.DescribeImageReplicationStatusResult;
import com.amazonaws.services.ecr.model.DescribeImageScanFindingsRequest;
import com.amazonaws.services.ecr.model.DescribeImageScanFindingsResult;
import com.amazonaws.services.ecr.model.DescribeImagesRequest;
import com.amazonaws.services.ecr.model.DescribeImagesResult;
import com.amazonaws.services.ecr.model.DescribePullThroughCacheRulesRequest;
import com.amazonaws.services.ecr.model.DescribePullThroughCacheRulesResult;
import com.amazonaws.services.ecr.model.DescribeRegistryRequest;
import com.amazonaws.services.ecr.model.DescribeRegistryResult;
import com.amazonaws.services.ecr.model.DescribeRepositoriesRequest;
import com.amazonaws.services.ecr.model.DescribeRepositoriesResult;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerRequest;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerResult;
import com.amazonaws.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import com.amazonaws.services.ecr.model.GetLifecyclePolicyPreviewResult;
import com.amazonaws.services.ecr.model.GetLifecyclePolicyRequest;
import com.amazonaws.services.ecr.model.GetLifecyclePolicyResult;
import com.amazonaws.services.ecr.model.GetRegistryPolicyRequest;
import com.amazonaws.services.ecr.model.GetRegistryPolicyResult;
import com.amazonaws.services.ecr.model.GetRegistryScanningConfigurationRequest;
import com.amazonaws.services.ecr.model.GetRegistryScanningConfigurationResult;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.InitiateLayerUploadRequest;
import com.amazonaws.services.ecr.model.InitiateLayerUploadResult;
import com.amazonaws.services.ecr.model.ListImagesRequest;
import com.amazonaws.services.ecr.model.ListImagesResult;
import com.amazonaws.services.ecr.model.ListTagsForResourceRequest;
import com.amazonaws.services.ecr.model.ListTagsForResourceResult;
import com.amazonaws.services.ecr.model.PutImageRequest;
import com.amazonaws.services.ecr.model.PutImageResult;
import com.amazonaws.services.ecr.model.PutImageScanningConfigurationRequest;
import com.amazonaws.services.ecr.model.PutImageScanningConfigurationResult;
import com.amazonaws.services.ecr.model.PutImageTagMutabilityRequest;
import com.amazonaws.services.ecr.model.PutImageTagMutabilityResult;
import com.amazonaws.services.ecr.model.PutLifecyclePolicyRequest;
import com.amazonaws.services.ecr.model.PutLifecyclePolicyResult;
import com.amazonaws.services.ecr.model.PutRegistryPolicyRequest;
import com.amazonaws.services.ecr.model.PutRegistryPolicyResult;
import com.amazonaws.services.ecr.model.PutRegistryScanningConfigurationRequest;
import com.amazonaws.services.ecr.model.PutRegistryScanningConfigurationResult;
import com.amazonaws.services.ecr.model.PutReplicationConfigurationRequest;
import com.amazonaws.services.ecr.model.PutReplicationConfigurationResult;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.StartImageScanRequest;
import com.amazonaws.services.ecr.model.StartImageScanResult;
import com.amazonaws.services.ecr.model.StartLifecyclePolicyPreviewRequest;
import com.amazonaws.services.ecr.model.StartLifecyclePolicyPreviewResult;
import com.amazonaws.services.ecr.model.TagResourceRequest;
import com.amazonaws.services.ecr.model.TagResourceResult;
import com.amazonaws.services.ecr.model.UntagResourceRequest;
import com.amazonaws.services.ecr.model.UntagResourceResult;
import com.amazonaws.services.ecr.model.UploadLayerPartRequest;
import com.amazonaws.services.ecr.model.UploadLayerPartResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonECRAsyncClient
extends AmazonECRClient
implements AmazonECRAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonECRAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonECRAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonECRAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonECRAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonECRAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonECRAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonECRAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonECRAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonECRAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonECRAsyncClientBuilder asyncBuilder() {
        return AmazonECRAsyncClientBuilder.standard();
    }

    AmazonECRAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonECRAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchCheckLayerAvailabilityResult> batchCheckLayerAvailabilityAsync(BatchCheckLayerAvailabilityRequest request) {
        return this.batchCheckLayerAvailabilityAsync(request, null);
    }

    @Override
    public Future<BatchCheckLayerAvailabilityResult> batchCheckLayerAvailabilityAsync(BatchCheckLayerAvailabilityRequest request, final AsyncHandler<BatchCheckLayerAvailabilityRequest, BatchCheckLayerAvailabilityResult> asyncHandler) {
        final BatchCheckLayerAvailabilityRequest finalRequest = (BatchCheckLayerAvailabilityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchCheckLayerAvailabilityResult>(){

            @Override
            public BatchCheckLayerAvailabilityResult call() throws Exception {
                BatchCheckLayerAvailabilityResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeBatchCheckLayerAvailability(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDeleteImageResult> batchDeleteImageAsync(BatchDeleteImageRequest request) {
        return this.batchDeleteImageAsync(request, null);
    }

    @Override
    public Future<BatchDeleteImageResult> batchDeleteImageAsync(BatchDeleteImageRequest request, final AsyncHandler<BatchDeleteImageRequest, BatchDeleteImageResult> asyncHandler) {
        final BatchDeleteImageRequest finalRequest = (BatchDeleteImageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDeleteImageResult>(){

            @Override
            public BatchDeleteImageResult call() throws Exception {
                BatchDeleteImageResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeBatchDeleteImage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetImageResult> batchGetImageAsync(BatchGetImageRequest request) {
        return this.batchGetImageAsync(request, null);
    }

    @Override
    public Future<BatchGetImageResult> batchGetImageAsync(BatchGetImageRequest request, final AsyncHandler<BatchGetImageRequest, BatchGetImageResult> asyncHandler) {
        final BatchGetImageRequest finalRequest = (BatchGetImageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetImageResult>(){

            @Override
            public BatchGetImageResult call() throws Exception {
                BatchGetImageResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeBatchGetImage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetRepositoryScanningConfigurationResult> batchGetRepositoryScanningConfigurationAsync(BatchGetRepositoryScanningConfigurationRequest request) {
        return this.batchGetRepositoryScanningConfigurationAsync(request, null);
    }

    @Override
    public Future<BatchGetRepositoryScanningConfigurationResult> batchGetRepositoryScanningConfigurationAsync(BatchGetRepositoryScanningConfigurationRequest request, final AsyncHandler<BatchGetRepositoryScanningConfigurationRequest, BatchGetRepositoryScanningConfigurationResult> asyncHandler) {
        final BatchGetRepositoryScanningConfigurationRequest finalRequest = (BatchGetRepositoryScanningConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetRepositoryScanningConfigurationResult>(){

            @Override
            public BatchGetRepositoryScanningConfigurationResult call() throws Exception {
                BatchGetRepositoryScanningConfigurationResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeBatchGetRepositoryScanningConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CompleteLayerUploadResult> completeLayerUploadAsync(CompleteLayerUploadRequest request) {
        return this.completeLayerUploadAsync(request, null);
    }

    @Override
    public Future<CompleteLayerUploadResult> completeLayerUploadAsync(CompleteLayerUploadRequest request, final AsyncHandler<CompleteLayerUploadRequest, CompleteLayerUploadResult> asyncHandler) {
        final CompleteLayerUploadRequest finalRequest = (CompleteLayerUploadRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CompleteLayerUploadResult>(){

            @Override
            public CompleteLayerUploadResult call() throws Exception {
                CompleteLayerUploadResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeCompleteLayerUpload(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePullThroughCacheRuleResult> createPullThroughCacheRuleAsync(CreatePullThroughCacheRuleRequest request) {
        return this.createPullThroughCacheRuleAsync(request, null);
    }

    @Override
    public Future<CreatePullThroughCacheRuleResult> createPullThroughCacheRuleAsync(CreatePullThroughCacheRuleRequest request, final AsyncHandler<CreatePullThroughCacheRuleRequest, CreatePullThroughCacheRuleResult> asyncHandler) {
        final CreatePullThroughCacheRuleRequest finalRequest = (CreatePullThroughCacheRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePullThroughCacheRuleResult>(){

            @Override
            public CreatePullThroughCacheRuleResult call() throws Exception {
                CreatePullThroughCacheRuleResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeCreatePullThroughCacheRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryAsync(request, null);
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(CreateRepositoryRequest request, final AsyncHandler<CreateRepositoryRequest, CreateRepositoryResult> asyncHandler) {
        final CreateRepositoryRequest finalRequest = (CreateRepositoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRepositoryResult>(){

            @Override
            public CreateRepositoryResult call() throws Exception {
                CreateRepositoryResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeCreateRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLifecyclePolicyResult> deleteLifecyclePolicyAsync(DeleteLifecyclePolicyRequest request) {
        return this.deleteLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<DeleteLifecyclePolicyResult> deleteLifecyclePolicyAsync(DeleteLifecyclePolicyRequest request, final AsyncHandler<DeleteLifecyclePolicyRequest, DeleteLifecyclePolicyResult> asyncHandler) {
        final DeleteLifecyclePolicyRequest finalRequest = (DeleteLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLifecyclePolicyResult>(){

            @Override
            public DeleteLifecyclePolicyResult call() throws Exception {
                DeleteLifecyclePolicyResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDeleteLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePullThroughCacheRuleResult> deletePullThroughCacheRuleAsync(DeletePullThroughCacheRuleRequest request) {
        return this.deletePullThroughCacheRuleAsync(request, null);
    }

    @Override
    public Future<DeletePullThroughCacheRuleResult> deletePullThroughCacheRuleAsync(DeletePullThroughCacheRuleRequest request, final AsyncHandler<DeletePullThroughCacheRuleRequest, DeletePullThroughCacheRuleResult> asyncHandler) {
        final DeletePullThroughCacheRuleRequest finalRequest = (DeletePullThroughCacheRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePullThroughCacheRuleResult>(){

            @Override
            public DeletePullThroughCacheRuleResult call() throws Exception {
                DeletePullThroughCacheRuleResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDeletePullThroughCacheRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRegistryPolicyResult> deleteRegistryPolicyAsync(DeleteRegistryPolicyRequest request) {
        return this.deleteRegistryPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteRegistryPolicyResult> deleteRegistryPolicyAsync(DeleteRegistryPolicyRequest request, final AsyncHandler<DeleteRegistryPolicyRequest, DeleteRegistryPolicyResult> asyncHandler) {
        final DeleteRegistryPolicyRequest finalRequest = (DeleteRegistryPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRegistryPolicyResult>(){

            @Override
            public DeleteRegistryPolicyResult call() throws Exception {
                DeleteRegistryPolicyResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDeleteRegistryPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryAsync(request, null);
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(DeleteRepositoryRequest request, final AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResult> asyncHandler) {
        final DeleteRepositoryRequest finalRequest = (DeleteRepositoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRepositoryResult>(){

            @Override
            public DeleteRepositoryResult call() throws Exception {
                DeleteRepositoryResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDeleteRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryPolicyResult> deleteRepositoryPolicyAsync(DeleteRepositoryPolicyRequest request) {
        return this.deleteRepositoryPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteRepositoryPolicyResult> deleteRepositoryPolicyAsync(DeleteRepositoryPolicyRequest request, final AsyncHandler<DeleteRepositoryPolicyRequest, DeleteRepositoryPolicyResult> asyncHandler) {
        final DeleteRepositoryPolicyRequest finalRequest = (DeleteRepositoryPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRepositoryPolicyResult>(){

            @Override
            public DeleteRepositoryPolicyResult call() throws Exception {
                DeleteRepositoryPolicyResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDeleteRepositoryPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeImageReplicationStatusResult> describeImageReplicationStatusAsync(DescribeImageReplicationStatusRequest request) {
        return this.describeImageReplicationStatusAsync(request, null);
    }

    @Override
    public Future<DescribeImageReplicationStatusResult> describeImageReplicationStatusAsync(DescribeImageReplicationStatusRequest request, final AsyncHandler<DescribeImageReplicationStatusRequest, DescribeImageReplicationStatusResult> asyncHandler) {
        final DescribeImageReplicationStatusRequest finalRequest = (DescribeImageReplicationStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeImageReplicationStatusResult>(){

            @Override
            public DescribeImageReplicationStatusResult call() throws Exception {
                DescribeImageReplicationStatusResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDescribeImageReplicationStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeImageScanFindingsResult> describeImageScanFindingsAsync(DescribeImageScanFindingsRequest request) {
        return this.describeImageScanFindingsAsync(request, null);
    }

    @Override
    public Future<DescribeImageScanFindingsResult> describeImageScanFindingsAsync(DescribeImageScanFindingsRequest request, final AsyncHandler<DescribeImageScanFindingsRequest, DescribeImageScanFindingsResult> asyncHandler) {
        final DescribeImageScanFindingsRequest finalRequest = (DescribeImageScanFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeImageScanFindingsResult>(){

            @Override
            public DescribeImageScanFindingsResult call() throws Exception {
                DescribeImageScanFindingsResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDescribeImageScanFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(DescribeImagesRequest request) {
        return this.describeImagesAsync(request, null);
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(DescribeImagesRequest request, final AsyncHandler<DescribeImagesRequest, DescribeImagesResult> asyncHandler) {
        final DescribeImagesRequest finalRequest = (DescribeImagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeImagesResult>(){

            @Override
            public DescribeImagesResult call() throws Exception {
                DescribeImagesResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDescribeImages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePullThroughCacheRulesResult> describePullThroughCacheRulesAsync(DescribePullThroughCacheRulesRequest request) {
        return this.describePullThroughCacheRulesAsync(request, null);
    }

    @Override
    public Future<DescribePullThroughCacheRulesResult> describePullThroughCacheRulesAsync(DescribePullThroughCacheRulesRequest request, final AsyncHandler<DescribePullThroughCacheRulesRequest, DescribePullThroughCacheRulesResult> asyncHandler) {
        final DescribePullThroughCacheRulesRequest finalRequest = (DescribePullThroughCacheRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePullThroughCacheRulesResult>(){

            @Override
            public DescribePullThroughCacheRulesResult call() throws Exception {
                DescribePullThroughCacheRulesResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDescribePullThroughCacheRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRegistryResult> describeRegistryAsync(DescribeRegistryRequest request) {
        return this.describeRegistryAsync(request, null);
    }

    @Override
    public Future<DescribeRegistryResult> describeRegistryAsync(DescribeRegistryRequest request, final AsyncHandler<DescribeRegistryRequest, DescribeRegistryResult> asyncHandler) {
        final DescribeRegistryRequest finalRequest = (DescribeRegistryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRegistryResult>(){

            @Override
            public DescribeRegistryResult call() throws Exception {
                DescribeRegistryResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDescribeRegistry(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRepositoriesResult> describeRepositoriesAsync(DescribeRepositoriesRequest request) {
        return this.describeRepositoriesAsync(request, null);
    }

    @Override
    public Future<DescribeRepositoriesResult> describeRepositoriesAsync(DescribeRepositoriesRequest request, final AsyncHandler<DescribeRepositoriesRequest, DescribeRepositoriesResult> asyncHandler) {
        final DescribeRepositoriesRequest finalRequest = (DescribeRepositoriesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRepositoriesResult>(){

            @Override
            public DescribeRepositoriesResult call() throws Exception {
                DescribeRepositoriesResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeDescribeRepositories(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAuthorizationTokenResult> getAuthorizationTokenAsync(GetAuthorizationTokenRequest request) {
        return this.getAuthorizationTokenAsync(request, null);
    }

    @Override
    public Future<GetAuthorizationTokenResult> getAuthorizationTokenAsync(GetAuthorizationTokenRequest request, final AsyncHandler<GetAuthorizationTokenRequest, GetAuthorizationTokenResult> asyncHandler) {
        final GetAuthorizationTokenRequest finalRequest = (GetAuthorizationTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAuthorizationTokenResult>(){

            @Override
            public GetAuthorizationTokenResult call() throws Exception {
                GetAuthorizationTokenResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeGetAuthorizationToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDownloadUrlForLayerResult> getDownloadUrlForLayerAsync(GetDownloadUrlForLayerRequest request) {
        return this.getDownloadUrlForLayerAsync(request, null);
    }

    @Override
    public Future<GetDownloadUrlForLayerResult> getDownloadUrlForLayerAsync(GetDownloadUrlForLayerRequest request, final AsyncHandler<GetDownloadUrlForLayerRequest, GetDownloadUrlForLayerResult> asyncHandler) {
        final GetDownloadUrlForLayerRequest finalRequest = (GetDownloadUrlForLayerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDownloadUrlForLayerResult>(){

            @Override
            public GetDownloadUrlForLayerResult call() throws Exception {
                GetDownloadUrlForLayerResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeGetDownloadUrlForLayer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLifecyclePolicyResult> getLifecyclePolicyAsync(GetLifecyclePolicyRequest request) {
        return this.getLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<GetLifecyclePolicyResult> getLifecyclePolicyAsync(GetLifecyclePolicyRequest request, final AsyncHandler<GetLifecyclePolicyRequest, GetLifecyclePolicyResult> asyncHandler) {
        final GetLifecyclePolicyRequest finalRequest = (GetLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLifecyclePolicyResult>(){

            @Override
            public GetLifecyclePolicyResult call() throws Exception {
                GetLifecyclePolicyResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeGetLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLifecyclePolicyPreviewResult> getLifecyclePolicyPreviewAsync(GetLifecyclePolicyPreviewRequest request) {
        return this.getLifecyclePolicyPreviewAsync(request, null);
    }

    @Override
    public Future<GetLifecyclePolicyPreviewResult> getLifecyclePolicyPreviewAsync(GetLifecyclePolicyPreviewRequest request, final AsyncHandler<GetLifecyclePolicyPreviewRequest, GetLifecyclePolicyPreviewResult> asyncHandler) {
        final GetLifecyclePolicyPreviewRequest finalRequest = (GetLifecyclePolicyPreviewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLifecyclePolicyPreviewResult>(){

            @Override
            public GetLifecyclePolicyPreviewResult call() throws Exception {
                GetLifecyclePolicyPreviewResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeGetLifecyclePolicyPreview(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRegistryPolicyResult> getRegistryPolicyAsync(GetRegistryPolicyRequest request) {
        return this.getRegistryPolicyAsync(request, null);
    }

    @Override
    public Future<GetRegistryPolicyResult> getRegistryPolicyAsync(GetRegistryPolicyRequest request, final AsyncHandler<GetRegistryPolicyRequest, GetRegistryPolicyResult> asyncHandler) {
        final GetRegistryPolicyRequest finalRequest = (GetRegistryPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRegistryPolicyResult>(){

            @Override
            public GetRegistryPolicyResult call() throws Exception {
                GetRegistryPolicyResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeGetRegistryPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRegistryScanningConfigurationResult> getRegistryScanningConfigurationAsync(GetRegistryScanningConfigurationRequest request) {
        return this.getRegistryScanningConfigurationAsync(request, null);
    }

    @Override
    public Future<GetRegistryScanningConfigurationResult> getRegistryScanningConfigurationAsync(GetRegistryScanningConfigurationRequest request, final AsyncHandler<GetRegistryScanningConfigurationRequest, GetRegistryScanningConfigurationResult> asyncHandler) {
        final GetRegistryScanningConfigurationRequest finalRequest = (GetRegistryScanningConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRegistryScanningConfigurationResult>(){

            @Override
            public GetRegistryScanningConfigurationResult call() throws Exception {
                GetRegistryScanningConfigurationResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeGetRegistryScanningConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryPolicyResult> getRepositoryPolicyAsync(GetRepositoryPolicyRequest request) {
        return this.getRepositoryPolicyAsync(request, null);
    }

    @Override
    public Future<GetRepositoryPolicyResult> getRepositoryPolicyAsync(GetRepositoryPolicyRequest request, final AsyncHandler<GetRepositoryPolicyRequest, GetRepositoryPolicyResult> asyncHandler) {
        final GetRepositoryPolicyRequest finalRequest = (GetRepositoryPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRepositoryPolicyResult>(){

            @Override
            public GetRepositoryPolicyResult call() throws Exception {
                GetRepositoryPolicyResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeGetRepositoryPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitiateLayerUploadResult> initiateLayerUploadAsync(InitiateLayerUploadRequest request) {
        return this.initiateLayerUploadAsync(request, null);
    }

    @Override
    public Future<InitiateLayerUploadResult> initiateLayerUploadAsync(InitiateLayerUploadRequest request, final AsyncHandler<InitiateLayerUploadRequest, InitiateLayerUploadResult> asyncHandler) {
        final InitiateLayerUploadRequest finalRequest = (InitiateLayerUploadRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InitiateLayerUploadResult>(){

            @Override
            public InitiateLayerUploadResult call() throws Exception {
                InitiateLayerUploadResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeInitiateLayerUpload(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListImagesResult> listImagesAsync(ListImagesRequest request) {
        return this.listImagesAsync(request, null);
    }

    @Override
    public Future<ListImagesResult> listImagesAsync(ListImagesRequest request, final AsyncHandler<ListImagesRequest, ListImagesResult> asyncHandler) {
        final ListImagesRequest finalRequest = (ListImagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListImagesResult>(){

            @Override
            public ListImagesResult call() throws Exception {
                ListImagesResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeListImages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutImageResult> putImageAsync(PutImageRequest request) {
        return this.putImageAsync(request, null);
    }

    @Override
    public Future<PutImageResult> putImageAsync(PutImageRequest request, final AsyncHandler<PutImageRequest, PutImageResult> asyncHandler) {
        final PutImageRequest finalRequest = (PutImageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutImageResult>(){

            @Override
            public PutImageResult call() throws Exception {
                PutImageResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executePutImage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutImageScanningConfigurationResult> putImageScanningConfigurationAsync(PutImageScanningConfigurationRequest request) {
        return this.putImageScanningConfigurationAsync(request, null);
    }

    @Override
    public Future<PutImageScanningConfigurationResult> putImageScanningConfigurationAsync(PutImageScanningConfigurationRequest request, final AsyncHandler<PutImageScanningConfigurationRequest, PutImageScanningConfigurationResult> asyncHandler) {
        final PutImageScanningConfigurationRequest finalRequest = (PutImageScanningConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutImageScanningConfigurationResult>(){

            @Override
            public PutImageScanningConfigurationResult call() throws Exception {
                PutImageScanningConfigurationResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executePutImageScanningConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutImageTagMutabilityResult> putImageTagMutabilityAsync(PutImageTagMutabilityRequest request) {
        return this.putImageTagMutabilityAsync(request, null);
    }

    @Override
    public Future<PutImageTagMutabilityResult> putImageTagMutabilityAsync(PutImageTagMutabilityRequest request, final AsyncHandler<PutImageTagMutabilityRequest, PutImageTagMutabilityResult> asyncHandler) {
        final PutImageTagMutabilityRequest finalRequest = (PutImageTagMutabilityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutImageTagMutabilityResult>(){

            @Override
            public PutImageTagMutabilityResult call() throws Exception {
                PutImageTagMutabilityResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executePutImageTagMutability(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLifecyclePolicyResult> putLifecyclePolicyAsync(PutLifecyclePolicyRequest request) {
        return this.putLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<PutLifecyclePolicyResult> putLifecyclePolicyAsync(PutLifecyclePolicyRequest request, final AsyncHandler<PutLifecyclePolicyRequest, PutLifecyclePolicyResult> asyncHandler) {
        final PutLifecyclePolicyRequest finalRequest = (PutLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutLifecyclePolicyResult>(){

            @Override
            public PutLifecyclePolicyResult call() throws Exception {
                PutLifecyclePolicyResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executePutLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRegistryPolicyResult> putRegistryPolicyAsync(PutRegistryPolicyRequest request) {
        return this.putRegistryPolicyAsync(request, null);
    }

    @Override
    public Future<PutRegistryPolicyResult> putRegistryPolicyAsync(PutRegistryPolicyRequest request, final AsyncHandler<PutRegistryPolicyRequest, PutRegistryPolicyResult> asyncHandler) {
        final PutRegistryPolicyRequest finalRequest = (PutRegistryPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRegistryPolicyResult>(){

            @Override
            public PutRegistryPolicyResult call() throws Exception {
                PutRegistryPolicyResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executePutRegistryPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRegistryScanningConfigurationResult> putRegistryScanningConfigurationAsync(PutRegistryScanningConfigurationRequest request) {
        return this.putRegistryScanningConfigurationAsync(request, null);
    }

    @Override
    public Future<PutRegistryScanningConfigurationResult> putRegistryScanningConfigurationAsync(PutRegistryScanningConfigurationRequest request, final AsyncHandler<PutRegistryScanningConfigurationRequest, PutRegistryScanningConfigurationResult> asyncHandler) {
        final PutRegistryScanningConfigurationRequest finalRequest = (PutRegistryScanningConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRegistryScanningConfigurationResult>(){

            @Override
            public PutRegistryScanningConfigurationResult call() throws Exception {
                PutRegistryScanningConfigurationResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executePutRegistryScanningConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutReplicationConfigurationResult> putReplicationConfigurationAsync(PutReplicationConfigurationRequest request) {
        return this.putReplicationConfigurationAsync(request, null);
    }

    @Override
    public Future<PutReplicationConfigurationResult> putReplicationConfigurationAsync(PutReplicationConfigurationRequest request, final AsyncHandler<PutReplicationConfigurationRequest, PutReplicationConfigurationResult> asyncHandler) {
        final PutReplicationConfigurationRequest finalRequest = (PutReplicationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutReplicationConfigurationResult>(){

            @Override
            public PutReplicationConfigurationResult call() throws Exception {
                PutReplicationConfigurationResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executePutReplicationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetRepositoryPolicyResult> setRepositoryPolicyAsync(SetRepositoryPolicyRequest request) {
        return this.setRepositoryPolicyAsync(request, null);
    }

    @Override
    public Future<SetRepositoryPolicyResult> setRepositoryPolicyAsync(SetRepositoryPolicyRequest request, final AsyncHandler<SetRepositoryPolicyRequest, SetRepositoryPolicyResult> asyncHandler) {
        final SetRepositoryPolicyRequest finalRequest = (SetRepositoryPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetRepositoryPolicyResult>(){

            @Override
            public SetRepositoryPolicyResult call() throws Exception {
                SetRepositoryPolicyResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeSetRepositoryPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartImageScanResult> startImageScanAsync(StartImageScanRequest request) {
        return this.startImageScanAsync(request, null);
    }

    @Override
    public Future<StartImageScanResult> startImageScanAsync(StartImageScanRequest request, final AsyncHandler<StartImageScanRequest, StartImageScanResult> asyncHandler) {
        final StartImageScanRequest finalRequest = (StartImageScanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartImageScanResult>(){

            @Override
            public StartImageScanResult call() throws Exception {
                StartImageScanResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeStartImageScan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartLifecyclePolicyPreviewResult> startLifecyclePolicyPreviewAsync(StartLifecyclePolicyPreviewRequest request) {
        return this.startLifecyclePolicyPreviewAsync(request, null);
    }

    @Override
    public Future<StartLifecyclePolicyPreviewResult> startLifecyclePolicyPreviewAsync(StartLifecyclePolicyPreviewRequest request, final AsyncHandler<StartLifecyclePolicyPreviewRequest, StartLifecyclePolicyPreviewResult> asyncHandler) {
        final StartLifecyclePolicyPreviewRequest finalRequest = (StartLifecyclePolicyPreviewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartLifecyclePolicyPreviewResult>(){

            @Override
            public StartLifecyclePolicyPreviewResult call() throws Exception {
                StartLifecyclePolicyPreviewResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeStartLifecyclePolicyPreview(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UploadLayerPartResult> uploadLayerPartAsync(UploadLayerPartRequest request) {
        return this.uploadLayerPartAsync(request, null);
    }

    @Override
    public Future<UploadLayerPartResult> uploadLayerPartAsync(UploadLayerPartRequest request, final AsyncHandler<UploadLayerPartRequest, UploadLayerPartResult> asyncHandler) {
        final UploadLayerPartRequest finalRequest = (UploadLayerPartRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UploadLayerPartResult>(){

            @Override
            public UploadLayerPartResult call() throws Exception {
                UploadLayerPartResult result = null;
                try {
                    result = AmazonECRAsyncClient.this.executeUploadLayerPart(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

