/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.FleetCapacityReservationTenancy;
import com.amazonaws.services.ec2.model.FleetInstanceMatchCriteria;
import com.amazonaws.services.ec2.model.ReservationFleetInstanceSpecification;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateCapacityReservationFleetRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CreateCapacityReservationFleetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateCapacityReservationFleetRequest> {
    private String allocationStrategy;
    private String clientToken;
    private SdkInternalList<ReservationFleetInstanceSpecification> instanceTypeSpecifications;
    private String tenancy;
    private Integer totalTargetCapacity;
    private Date endDate;
    private String instanceMatchCriteria;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setAllocationStrategy(String allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
    }

    public String getAllocationStrategy() {
        return this.allocationStrategy;
    }

    public CreateCapacityReservationFleetRequest withAllocationStrategy(String allocationStrategy) {
        this.setAllocationStrategy(allocationStrategy);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateCapacityReservationFleetRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<ReservationFleetInstanceSpecification> getInstanceTypeSpecifications() {
        if (this.instanceTypeSpecifications == null) {
            this.instanceTypeSpecifications = new SdkInternalList();
        }
        return this.instanceTypeSpecifications;
    }

    public void setInstanceTypeSpecifications(Collection<ReservationFleetInstanceSpecification> instanceTypeSpecifications) {
        if (instanceTypeSpecifications == null) {
            this.instanceTypeSpecifications = null;
            return;
        }
        this.instanceTypeSpecifications = new SdkInternalList(instanceTypeSpecifications);
    }

    public CreateCapacityReservationFleetRequest withInstanceTypeSpecifications(ReservationFleetInstanceSpecification ... instanceTypeSpecifications) {
        if (this.instanceTypeSpecifications == null) {
            this.setInstanceTypeSpecifications((Collection<ReservationFleetInstanceSpecification>)new SdkInternalList(instanceTypeSpecifications.length));
        }
        for (ReservationFleetInstanceSpecification ele : instanceTypeSpecifications) {
            this.instanceTypeSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateCapacityReservationFleetRequest withInstanceTypeSpecifications(Collection<ReservationFleetInstanceSpecification> instanceTypeSpecifications) {
        this.setInstanceTypeSpecifications(instanceTypeSpecifications);
        return this;
    }

    public void setTenancy(String tenancy) {
        this.tenancy = tenancy;
    }

    public String getTenancy() {
        return this.tenancy;
    }

    public CreateCapacityReservationFleetRequest withTenancy(String tenancy) {
        this.setTenancy(tenancy);
        return this;
    }

    public CreateCapacityReservationFleetRequest withTenancy(FleetCapacityReservationTenancy tenancy) {
        this.tenancy = tenancy.toString();
        return this;
    }

    public void setTotalTargetCapacity(Integer totalTargetCapacity) {
        this.totalTargetCapacity = totalTargetCapacity;
    }

    public Integer getTotalTargetCapacity() {
        return this.totalTargetCapacity;
    }

    public CreateCapacityReservationFleetRequest withTotalTargetCapacity(Integer totalTargetCapacity) {
        this.setTotalTargetCapacity(totalTargetCapacity);
        return this;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public CreateCapacityReservationFleetRequest withEndDate(Date endDate) {
        this.setEndDate(endDate);
        return this;
    }

    public void setInstanceMatchCriteria(String instanceMatchCriteria) {
        this.instanceMatchCriteria = instanceMatchCriteria;
    }

    public String getInstanceMatchCriteria() {
        return this.instanceMatchCriteria;
    }

    public CreateCapacityReservationFleetRequest withInstanceMatchCriteria(String instanceMatchCriteria) {
        this.setInstanceMatchCriteria(instanceMatchCriteria);
        return this;
    }

    public CreateCapacityReservationFleetRequest withInstanceMatchCriteria(FleetInstanceMatchCriteria instanceMatchCriteria) {
        this.instanceMatchCriteria = instanceMatchCriteria.toString();
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateCapacityReservationFleetRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateCapacityReservationFleetRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateCapacityReservationFleetRequest> getDryRunRequest() {
        Request<CreateCapacityReservationFleetRequest> request = new CreateCapacityReservationFleetRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocationStrategy() != null) {
            sb.append("AllocationStrategy: ").append(this.getAllocationStrategy()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getInstanceTypeSpecifications() != null) {
            sb.append("InstanceTypeSpecifications: ").append(this.getInstanceTypeSpecifications()).append(",");
        }
        if (this.getTenancy() != null) {
            sb.append("Tenancy: ").append(this.getTenancy()).append(",");
        }
        if (this.getTotalTargetCapacity() != null) {
            sb.append("TotalTargetCapacity: ").append(this.getTotalTargetCapacity()).append(",");
        }
        if (this.getEndDate() != null) {
            sb.append("EndDate: ").append(this.getEndDate()).append(",");
        }
        if (this.getInstanceMatchCriteria() != null) {
            sb.append("InstanceMatchCriteria: ").append(this.getInstanceMatchCriteria()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityReservationFleetRequest)) {
            return false;
        }
        CreateCapacityReservationFleetRequest other = (CreateCapacityReservationFleetRequest)obj;
        if (other.getAllocationStrategy() == null ^ this.getAllocationStrategy() == null) {
            return false;
        }
        if (other.getAllocationStrategy() != null && !other.getAllocationStrategy().equals(this.getAllocationStrategy())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getInstanceTypeSpecifications() == null ^ this.getInstanceTypeSpecifications() == null) {
            return false;
        }
        if (other.getInstanceTypeSpecifications() != null && !other.getInstanceTypeSpecifications().equals(this.getInstanceTypeSpecifications())) {
            return false;
        }
        if (other.getTenancy() == null ^ this.getTenancy() == null) {
            return false;
        }
        if (other.getTenancy() != null && !other.getTenancy().equals(this.getTenancy())) {
            return false;
        }
        if (other.getTotalTargetCapacity() == null ^ this.getTotalTargetCapacity() == null) {
            return false;
        }
        if (other.getTotalTargetCapacity() != null && !other.getTotalTargetCapacity().equals(this.getTotalTargetCapacity())) {
            return false;
        }
        if (other.getEndDate() == null ^ this.getEndDate() == null) {
            return false;
        }
        if (other.getEndDate() != null && !other.getEndDate().equals(this.getEndDate())) {
            return false;
        }
        if (other.getInstanceMatchCriteria() == null ^ this.getInstanceMatchCriteria() == null) {
            return false;
        }
        if (other.getInstanceMatchCriteria() != null && !other.getInstanceMatchCriteria().equals(this.getInstanceMatchCriteria())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocationStrategy() == null ? 0 : this.getAllocationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTypeSpecifications() == null ? 0 : this.getInstanceTypeSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getTenancy() == null ? 0 : this.getTenancy().hashCode());
        hashCode = 31 * hashCode + (this.getTotalTargetCapacity() == null ? 0 : this.getTotalTargetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getEndDate() == null ? 0 : this.getEndDate().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceMatchCriteria() == null ? 0 : this.getInstanceMatchCriteria().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    public CreateCapacityReservationFleetRequest clone() {
        return (CreateCapacityReservationFleetRequest)super.clone();
    }
}

