/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/**
 * ModifyVpcEndpointServiceConfigurationRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ModifyVpcEndpointServiceConfigurationRequestMarshaller implements
        Marshaller<Request<ModifyVpcEndpointServiceConfigurationRequest>, ModifyVpcEndpointServiceConfigurationRequest> {

    public Request<ModifyVpcEndpointServiceConfigurationRequest> marshall(
            ModifyVpcEndpointServiceConfigurationRequest modifyVpcEndpointServiceConfigurationRequest) {

        if (modifyVpcEndpointServiceConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyVpcEndpointServiceConfigurationRequest> request = new DefaultRequest<ModifyVpcEndpointServiceConfigurationRequest>(
                modifyVpcEndpointServiceConfigurationRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcEndpointServiceConfiguration");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifyVpcEndpointServiceConfigurationRequest.getServiceId() != null) {
            request.addParameter("ServiceId", StringUtils.fromString(modifyVpcEndpointServiceConfigurationRequest.getServiceId()));
        }

        if (modifyVpcEndpointServiceConfigurationRequest.getPrivateDnsName() != null) {
            request.addParameter("PrivateDnsName", StringUtils.fromString(modifyVpcEndpointServiceConfigurationRequest.getPrivateDnsName()));
        }

        if (modifyVpcEndpointServiceConfigurationRequest.getRemovePrivateDnsName() != null) {
            request.addParameter("RemovePrivateDnsName", StringUtils.fromBoolean(modifyVpcEndpointServiceConfigurationRequest.getRemovePrivateDnsName()));
        }

        if (modifyVpcEndpointServiceConfigurationRequest.getAcceptanceRequired() != null) {
            request.addParameter("AcceptanceRequired", StringUtils.fromBoolean(modifyVpcEndpointServiceConfigurationRequest.getAcceptanceRequired()));
        }

        com.amazonaws.internal.SdkInternalList<String> modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsList = (com.amazonaws.internal.SdkInternalList<String>) modifyVpcEndpointServiceConfigurationRequest
                .getAddNetworkLoadBalancerArns();
        if (!modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsList.isEmpty()
                || !modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsList.isAutoConstruct()) {
            int addNetworkLoadBalancerArnsListIndex = 1;

            for (String modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsListValue : modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsList) {
                if (modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsListValue != null) {
                    request.addParameter("AddNetworkLoadBalancerArn." + addNetworkLoadBalancerArnsListIndex,
                            StringUtils.fromString(modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsListValue));
                }
                addNetworkLoadBalancerArnsListIndex++;
            }
        }

        com.amazonaws.internal.SdkInternalList<String> modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsList = (com.amazonaws.internal.SdkInternalList<String>) modifyVpcEndpointServiceConfigurationRequest
                .getRemoveNetworkLoadBalancerArns();
        if (!modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsList.isEmpty()
                || !modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsList.isAutoConstruct()) {
            int removeNetworkLoadBalancerArnsListIndex = 1;

            for (String modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsListValue : modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsList) {
                if (modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsListValue != null) {
                    request.addParameter("RemoveNetworkLoadBalancerArn." + removeNetworkLoadBalancerArnsListIndex,
                            StringUtils.fromString(modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsListValue));
                }
                removeNetworkLoadBalancerArnsListIndex++;
            }
        }

        com.amazonaws.internal.SdkInternalList<String> modifyVpcEndpointServiceConfigurationRequestAddGatewayLoadBalancerArnsList = (com.amazonaws.internal.SdkInternalList<String>) modifyVpcEndpointServiceConfigurationRequest
                .getAddGatewayLoadBalancerArns();
        if (!modifyVpcEndpointServiceConfigurationRequestAddGatewayLoadBalancerArnsList.isEmpty()
                || !modifyVpcEndpointServiceConfigurationRequestAddGatewayLoadBalancerArnsList.isAutoConstruct()) {
            int addGatewayLoadBalancerArnsListIndex = 1;

            for (String modifyVpcEndpointServiceConfigurationRequestAddGatewayLoadBalancerArnsListValue : modifyVpcEndpointServiceConfigurationRequestAddGatewayLoadBalancerArnsList) {
                if (modifyVpcEndpointServiceConfigurationRequestAddGatewayLoadBalancerArnsListValue != null) {
                    request.addParameter("AddGatewayLoadBalancerArn." + addGatewayLoadBalancerArnsListIndex,
                            StringUtils.fromString(modifyVpcEndpointServiceConfigurationRequestAddGatewayLoadBalancerArnsListValue));
                }
                addGatewayLoadBalancerArnsListIndex++;
            }
        }

        com.amazonaws.internal.SdkInternalList<String> modifyVpcEndpointServiceConfigurationRequestRemoveGatewayLoadBalancerArnsList = (com.amazonaws.internal.SdkInternalList<String>) modifyVpcEndpointServiceConfigurationRequest
                .getRemoveGatewayLoadBalancerArns();
        if (!modifyVpcEndpointServiceConfigurationRequestRemoveGatewayLoadBalancerArnsList.isEmpty()
                || !modifyVpcEndpointServiceConfigurationRequestRemoveGatewayLoadBalancerArnsList.isAutoConstruct()) {
            int removeGatewayLoadBalancerArnsListIndex = 1;

            for (String modifyVpcEndpointServiceConfigurationRequestRemoveGatewayLoadBalancerArnsListValue : modifyVpcEndpointServiceConfigurationRequestRemoveGatewayLoadBalancerArnsList) {
                if (modifyVpcEndpointServiceConfigurationRequestRemoveGatewayLoadBalancerArnsListValue != null) {
                    request.addParameter("RemoveGatewayLoadBalancerArn." + removeGatewayLoadBalancerArnsListIndex,
                            StringUtils.fromString(modifyVpcEndpointServiceConfigurationRequestRemoveGatewayLoadBalancerArnsListValue));
                }
                removeGatewayLoadBalancerArnsListIndex++;
            }
        }

        com.amazonaws.internal.SdkInternalList<String> modifyVpcEndpointServiceConfigurationRequestAddSupportedIpAddressTypesList = (com.amazonaws.internal.SdkInternalList<String>) modifyVpcEndpointServiceConfigurationRequest
                .getAddSupportedIpAddressTypes();
        if (!modifyVpcEndpointServiceConfigurationRequestAddSupportedIpAddressTypesList.isEmpty()
                || !modifyVpcEndpointServiceConfigurationRequestAddSupportedIpAddressTypesList.isAutoConstruct()) {
            int addSupportedIpAddressTypesListIndex = 1;

            for (String modifyVpcEndpointServiceConfigurationRequestAddSupportedIpAddressTypesListValue : modifyVpcEndpointServiceConfigurationRequestAddSupportedIpAddressTypesList) {
                if (modifyVpcEndpointServiceConfigurationRequestAddSupportedIpAddressTypesListValue != null) {
                    request.addParameter("AddSupportedIpAddressType." + addSupportedIpAddressTypesListIndex,
                            StringUtils.fromString(modifyVpcEndpointServiceConfigurationRequestAddSupportedIpAddressTypesListValue));
                }
                addSupportedIpAddressTypesListIndex++;
            }
        }

        com.amazonaws.internal.SdkInternalList<String> modifyVpcEndpointServiceConfigurationRequestRemoveSupportedIpAddressTypesList = (com.amazonaws.internal.SdkInternalList<String>) modifyVpcEndpointServiceConfigurationRequest
                .getRemoveSupportedIpAddressTypes();
        if (!modifyVpcEndpointServiceConfigurationRequestRemoveSupportedIpAddressTypesList.isEmpty()
                || !modifyVpcEndpointServiceConfigurationRequestRemoveSupportedIpAddressTypesList.isAutoConstruct()) {
            int removeSupportedIpAddressTypesListIndex = 1;

            for (String modifyVpcEndpointServiceConfigurationRequestRemoveSupportedIpAddressTypesListValue : modifyVpcEndpointServiceConfigurationRequestRemoveSupportedIpAddressTypesList) {
                if (modifyVpcEndpointServiceConfigurationRequestRemoveSupportedIpAddressTypesListValue != null) {
                    request.addParameter("RemoveSupportedIpAddressType." + removeSupportedIpAddressTypesListIndex,
                            StringUtils.fromString(modifyVpcEndpointServiceConfigurationRequestRemoveSupportedIpAddressTypesListValue));
                }
                removeSupportedIpAddressTypesListIndex++;
            }
        }

        return request;
    }

}
