/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ExportTransitGatewayRoutesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ExportTransitGatewayRoutesRequestMarshaller
implements Marshaller<Request<ExportTransitGatewayRoutesRequest>, ExportTransitGatewayRoutesRequest> {
    public Request<ExportTransitGatewayRoutesRequest> marshall(ExportTransitGatewayRoutesRequest exportTransitGatewayRoutesRequest) {
        SdkInternalList exportTransitGatewayRoutesRequestFiltersList;
        if (exportTransitGatewayRoutesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)exportTransitGatewayRoutesRequest, "AmazonEC2");
        request.addParameter("Action", "ExportTransitGatewayRoutes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (exportTransitGatewayRoutesRequest.getTransitGatewayRouteTableId() != null) {
            request.addParameter("TransitGatewayRouteTableId", StringUtils.fromString((String)exportTransitGatewayRoutesRequest.getTransitGatewayRouteTableId()));
        }
        if (!(exportTransitGatewayRoutesRequestFiltersList = (SdkInternalList)exportTransitGatewayRoutesRequest.getFilters()).isEmpty() || !exportTransitGatewayRoutesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter exportTransitGatewayRoutesRequestFiltersListValue : exportTransitGatewayRoutesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (exportTransitGatewayRoutesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)exportTransitGatewayRoutesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)exportTransitGatewayRoutesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (exportTransitGatewayRoutesRequest.getS3Bucket() != null) {
            request.addParameter("S3Bucket", StringUtils.fromString((String)exportTransitGatewayRoutesRequest.getS3Bucket()));
        }
        return request;
    }
}

