/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInternetGatewaysRequestMarshaller
implements Marshaller<Request<DescribeInternetGatewaysRequest>, DescribeInternetGatewaysRequest> {
    public Request<DescribeInternetGatewaysRequest> marshall(DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        SdkInternalList describeInternetGatewaysRequestInternetGatewayIdsList;
        if (describeInternetGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInternetGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInternetGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeInternetGatewaysRequestFiltersList = (SdkInternalList)describeInternetGatewaysRequest.getFilters();
        if (!describeInternetGatewaysRequestFiltersList.isEmpty() || !describeInternetGatewaysRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInternetGatewaysRequestFiltersListValue : describeInternetGatewaysRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInternetGatewaysRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeInternetGatewaysRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInternetGatewaysRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeInternetGatewaysRequestInternetGatewayIdsList = (SdkInternalList)describeInternetGatewaysRequest.getInternetGatewayIds()).isEmpty() || !describeInternetGatewaysRequestInternetGatewayIdsList.isAutoConstruct()) {
            int internetGatewayIdsListIndex = 1;
            for (String describeInternetGatewaysRequestInternetGatewayIdsListValue : describeInternetGatewaysRequestInternetGatewayIdsList) {
                if (describeInternetGatewaysRequestInternetGatewayIdsListValue != null) {
                    request.addParameter("InternetGatewayId." + internetGatewayIdsListIndex, StringUtils.fromString((String)describeInternetGatewaysRequestInternetGatewayIdsListValue));
                }
                ++internetGatewayIdsListIndex;
            }
        }
        if (describeInternetGatewaysRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInternetGatewaysRequest.getNextToken()));
        }
        if (describeInternetGatewaysRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeInternetGatewaysRequest.getMaxResults()));
        }
        return request;
    }
}

