/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AddIpamOperatingRegion;
import com.amazonaws.services.ec2.model.ModifyIpamRequest;
import com.amazonaws.services.ec2.model.RemoveIpamOperatingRegion;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyIpamRequestMarshaller
implements Marshaller<Request<ModifyIpamRequest>, ModifyIpamRequest> {
    public Request<ModifyIpamRequest> marshall(ModifyIpamRequest modifyIpamRequest) {
        SdkInternalList modifyIpamRequestRemoveOperatingRegionsList;
        SdkInternalList modifyIpamRequestAddOperatingRegionsList;
        if (modifyIpamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyIpamRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyIpam");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyIpamRequest.getIpamId() != null) {
            request.addParameter("IpamId", StringUtils.fromString((String)modifyIpamRequest.getIpamId()));
        }
        if (modifyIpamRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyIpamRequest.getDescription()));
        }
        if (!(modifyIpamRequestAddOperatingRegionsList = (SdkInternalList)modifyIpamRequest.getAddOperatingRegions()).isEmpty() || !modifyIpamRequestAddOperatingRegionsList.isAutoConstruct()) {
            int addOperatingRegionsListIndex = 1;
            for (AddIpamOperatingRegion modifyIpamRequestAddOperatingRegionsListValue : modifyIpamRequestAddOperatingRegionsList) {
                if (modifyIpamRequestAddOperatingRegionsListValue.getRegionName() != null) {
                    request.addParameter("AddOperatingRegion." + addOperatingRegionsListIndex + ".RegionName", StringUtils.fromString((String)modifyIpamRequestAddOperatingRegionsListValue.getRegionName()));
                }
                ++addOperatingRegionsListIndex;
            }
        }
        if (!(modifyIpamRequestRemoveOperatingRegionsList = (SdkInternalList)modifyIpamRequest.getRemoveOperatingRegions()).isEmpty() || !modifyIpamRequestRemoveOperatingRegionsList.isAutoConstruct()) {
            int removeOperatingRegionsListIndex = 1;
            for (RemoveIpamOperatingRegion modifyIpamRequestRemoveOperatingRegionsListValue : modifyIpamRequestRemoveOperatingRegionsList) {
                if (modifyIpamRequestRemoveOperatingRegionsListValue.getRegionName() != null) {
                    request.addParameter("RemoveOperatingRegion." + removeOperatingRegionsListIndex + ".RegionName", StringUtils.fromString((String)modifyIpamRequestRemoveOperatingRegionsListValue.getRegionName()));
                }
                ++removeOperatingRegionsListIndex;
            }
        }
        return request;
    }
}

