/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.AllocateAddressRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AllocateAddressRequestMarshaller
implements Marshaller<Request<AllocateAddressRequest>, AllocateAddressRequest> {
    public Request<AllocateAddressRequest> marshall(AllocateAddressRequest allocateAddressRequest) {
        if (allocateAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)allocateAddressRequest, "AmazonEC2");
        request.addParameter("Action", "AllocateAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (allocateAddressRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)allocateAddressRequest.getDomain()));
        }
        if (allocateAddressRequest.getAddress() != null) {
            request.addParameter("Address", StringUtils.fromString((String)allocateAddressRequest.getAddress()));
        }
        if (allocateAddressRequest.getPublicIpv4Pool() != null) {
            request.addParameter("PublicIpv4Pool", StringUtils.fromString((String)allocateAddressRequest.getPublicIpv4Pool()));
        }
        if (allocateAddressRequest.getNetworkBorderGroup() != null) {
            request.addParameter("NetworkBorderGroup", StringUtils.fromString((String)allocateAddressRequest.getNetworkBorderGroup()));
        }
        if (allocateAddressRequest.getCustomerOwnedIpv4Pool() != null) {
            request.addParameter("CustomerOwnedIpv4Pool", StringUtils.fromString((String)allocateAddressRequest.getCustomerOwnedIpv4Pool()));
        }
        return request;
    }
}

