/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DiskImage;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification;
import com.amazonaws.services.ec2.model.PlatformValues;
import com.amazonaws.services.ec2.model.transform.ImportInstanceRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ImportInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ImportInstanceRequest> {
    private String description;
    private SdkInternalList<DiskImage> diskImages;
    private ImportInstanceLaunchSpecification launchSpecification;
    private String platform;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImportInstanceRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<DiskImage> getDiskImages() {
        if (this.diskImages == null) {
            this.diskImages = new SdkInternalList();
        }
        return this.diskImages;
    }

    public void setDiskImages(Collection<DiskImage> diskImages) {
        if (diskImages == null) {
            this.diskImages = null;
            return;
        }
        this.diskImages = new SdkInternalList(diskImages);
    }

    public ImportInstanceRequest withDiskImages(DiskImage ... diskImages) {
        if (this.diskImages == null) {
            this.setDiskImages((Collection<DiskImage>)new SdkInternalList(diskImages.length));
        }
        for (DiskImage ele : diskImages) {
            this.diskImages.add((Object)ele);
        }
        return this;
    }

    public ImportInstanceRequest withDiskImages(Collection<DiskImage> diskImages) {
        this.setDiskImages(diskImages);
        return this;
    }

    public void setLaunchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
    }

    public ImportInstanceLaunchSpecification getLaunchSpecification() {
        return this.launchSpecification;
    }

    public ImportInstanceRequest withLaunchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
        this.setLaunchSpecification(launchSpecification);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public ImportInstanceRequest withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setPlatform(PlatformValues platform) {
        this.withPlatform(platform);
    }

    public ImportInstanceRequest withPlatform(PlatformValues platform) {
        this.platform = platform.toString();
        return this;
    }

    @Override
    public Request<ImportInstanceRequest> getDryRunRequest() {
        Request<ImportInstanceRequest> request = new ImportInstanceRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDiskImages() != null) {
            sb.append("DiskImages: ").append(this.getDiskImages()).append(",");
        }
        if (this.getLaunchSpecification() != null) {
            sb.append("LaunchSpecification: ").append(this.getLaunchSpecification()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceRequest)) {
            return false;
        }
        ImportInstanceRequest other = (ImportInstanceRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDiskImages() == null ^ this.getDiskImages() == null) {
            return false;
        }
        if (other.getDiskImages() != null && !other.getDiskImages().equals(this.getDiskImages())) {
            return false;
        }
        if (other.getLaunchSpecification() == null ^ this.getLaunchSpecification() == null) {
            return false;
        }
        if (other.getLaunchSpecification() != null && !other.getLaunchSpecification().equals(this.getLaunchSpecification())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        return other.getPlatform() == null || other.getPlatform().equals(this.getPlatform());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDiskImages() == null ? 0 : this.getDiskImages().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecification() == null ? 0 : this.getLaunchSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        return hashCode;
    }

    public ImportInstanceRequest clone() {
        return (ImportInstanceRequest)super.clone();
    }
}

