/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.ParameterizedStatement;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExecuteTransactionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<ParameterizedStatement> transactStatements;
    private String clientRequestToken;
    private String returnConsumedCapacity;

    public List<ParameterizedStatement> getTransactStatements() {
        return this.transactStatements;
    }

    public void setTransactStatements(Collection<ParameterizedStatement> transactStatements) {
        if (transactStatements == null) {
            this.transactStatements = null;
            return;
        }
        this.transactStatements = new ArrayList<ParameterizedStatement>(transactStatements);
    }

    public ExecuteTransactionRequest withTransactStatements(ParameterizedStatement ... transactStatements) {
        if (this.transactStatements == null) {
            this.setTransactStatements(new ArrayList<ParameterizedStatement>(transactStatements.length));
        }
        for (ParameterizedStatement ele : transactStatements) {
            this.transactStatements.add(ele);
        }
        return this;
    }

    public ExecuteTransactionRequest withTransactStatements(Collection<ParameterizedStatement> transactStatements) {
        this.setTransactStatements(transactStatements);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public ExecuteTransactionRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public ExecuteTransactionRequest withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public ExecuteTransactionRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTransactStatements() != null) {
            sb.append("TransactStatements: ").append(this.getTransactStatements()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.getReturnConsumedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteTransactionRequest)) {
            return false;
        }
        ExecuteTransactionRequest other = (ExecuteTransactionRequest)obj;
        if (other.getTransactStatements() == null ^ this.getTransactStatements() == null) {
            return false;
        }
        if (other.getTransactStatements() != null && !other.getTransactStatements().equals(this.getTransactStatements())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        return other.getReturnConsumedCapacity() == null || other.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTransactStatements() == null ? 0 : this.getTransactStatements().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        return hashCode;
    }

    public ExecuteTransactionRequest clone() {
        return (ExecuteTransactionRequest)super.clone();
    }
}

