/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProjectionJsonMarshaller;
import java.util.List;

public class LocalSecondaryIndexDescriptionJsonMarshaller {
    private static LocalSecondaryIndexDescriptionJsonMarshaller instance;

    public void marshall(LocalSecondaryIndexDescription localSecondaryIndexDescription, StructuredJsonGenerator jsonGenerator) {
        if (localSecondaryIndexDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<KeySchemaElement> keySchemaList;
            jsonGenerator.writeStartObject();
            if (localSecondaryIndexDescription.getIndexName() != null) {
                jsonGenerator.writeFieldName("IndexName").writeValue(localSecondaryIndexDescription.getIndexName());
            }
            if ((keySchemaList = localSecondaryIndexDescription.getKeySchema()) != null) {
                jsonGenerator.writeFieldName("KeySchema");
                jsonGenerator.writeStartArray();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (localSecondaryIndexDescription.getProjection() != null) {
                jsonGenerator.writeFieldName("Projection");
                ProjectionJsonMarshaller.getInstance().marshall(localSecondaryIndexDescription.getProjection(), jsonGenerator);
            }
            if (localSecondaryIndexDescription.getIndexSizeBytes() != null) {
                jsonGenerator.writeFieldName("IndexSizeBytes").writeValue(localSecondaryIndexDescription.getIndexSizeBytes().longValue());
            }
            if (localSecondaryIndexDescription.getItemCount() != null) {
                jsonGenerator.writeFieldName("ItemCount").writeValue(localSecondaryIndexDescription.getItemCount().longValue());
            }
            if (localSecondaryIndexDescription.getIndexArn() != null) {
                jsonGenerator.writeFieldName("IndexArn").writeValue(localSecondaryIndexDescription.getIndexArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LocalSecondaryIndexDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LocalSecondaryIndexDescriptionJsonMarshaller();
        }
        return instance;
    }
}

