/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.drs.model.StartSourceNetworkRecoveryRequestNetworkEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartSourceNetworkRecoveryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Boolean deployAsNew;
    private List<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks;
    private Map<String, String> tags;

    public void setDeployAsNew(Boolean deployAsNew) {
        this.deployAsNew = deployAsNew;
    }

    public Boolean getDeployAsNew() {
        return this.deployAsNew;
    }

    public StartSourceNetworkRecoveryRequest withDeployAsNew(Boolean deployAsNew) {
        this.setDeployAsNew(deployAsNew);
        return this;
    }

    public Boolean isDeployAsNew() {
        return this.deployAsNew;
    }

    public List<StartSourceNetworkRecoveryRequestNetworkEntry> getSourceNetworks() {
        return this.sourceNetworks;
    }

    public void setSourceNetworks(Collection<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks) {
        if (sourceNetworks == null) {
            this.sourceNetworks = null;
            return;
        }
        this.sourceNetworks = new ArrayList<StartSourceNetworkRecoveryRequestNetworkEntry>(sourceNetworks);
    }

    public StartSourceNetworkRecoveryRequest withSourceNetworks(StartSourceNetworkRecoveryRequestNetworkEntry ... sourceNetworks) {
        if (this.sourceNetworks == null) {
            this.setSourceNetworks(new ArrayList<StartSourceNetworkRecoveryRequestNetworkEntry>(sourceNetworks.length));
        }
        for (StartSourceNetworkRecoveryRequestNetworkEntry ele : sourceNetworks) {
            this.sourceNetworks.add(ele);
        }
        return this;
    }

    public StartSourceNetworkRecoveryRequest withSourceNetworks(Collection<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks) {
        this.setSourceNetworks(sourceNetworks);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public StartSourceNetworkRecoveryRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public StartSourceNetworkRecoveryRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public StartSourceNetworkRecoveryRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeployAsNew() != null) {
            sb.append("DeployAsNew: ").append(this.getDeployAsNew()).append(",");
        }
        if (this.getSourceNetworks() != null) {
            sb.append("SourceNetworks: ").append(this.getSourceNetworks()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSourceNetworkRecoveryRequest)) {
            return false;
        }
        StartSourceNetworkRecoveryRequest other = (StartSourceNetworkRecoveryRequest)obj;
        if (other.getDeployAsNew() == null ^ this.getDeployAsNew() == null) {
            return false;
        }
        if (other.getDeployAsNew() != null && !other.getDeployAsNew().equals(this.getDeployAsNew())) {
            return false;
        }
        if (other.getSourceNetworks() == null ^ this.getSourceNetworks() == null) {
            return false;
        }
        if (other.getSourceNetworks() != null && !other.getSourceNetworks().equals(this.getSourceNetworks())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeployAsNew() == null ? 0 : this.getDeployAsNew().hashCode());
        hashCode = 31 * hashCode + (this.getSourceNetworks() == null ? 0 : this.getSourceNetworks().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StartSourceNetworkRecoveryRequest clone() {
        return (StartSourceNetworkRecoveryRequest)super.clone();
    }
}

