/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.drs.model.RecoverySnapshot;
import java.util.List;

@SdkInternalApi
public class RecoverySnapshotMarshaller {
    private static final MarshallingInfo<List> EBSSNAPSHOTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ebsSnapshots").build();
    private static final MarshallingInfo<String> EXPECTEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expectedTimestamp").build();
    private static final MarshallingInfo<String> SNAPSHOTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotID").build();
    private static final MarshallingInfo<String> SOURCESERVERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceServerID").build();
    private static final MarshallingInfo<String> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").build();
    private static final RecoverySnapshotMarshaller instance = new RecoverySnapshotMarshaller();

    public static RecoverySnapshotMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecoverySnapshot recoverySnapshot, ProtocolMarshaller protocolMarshaller) {
        if (recoverySnapshot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(recoverySnapshot.getEbsSnapshots(), EBSSNAPSHOTS_BINDING);
            protocolMarshaller.marshall((Object)recoverySnapshot.getExpectedTimestamp(), EXPECTEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)recoverySnapshot.getSnapshotID(), SNAPSHOTID_BINDING);
            protocolMarshaller.marshall((Object)recoverySnapshot.getSourceServerID(), SOURCESERVERID_BINDING);
            protocolMarshaller.marshall((Object)recoverySnapshot.getTimestamp(), TIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

