/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dlm.model.GettablePolicyStateValues;
import com.amazonaws.services.dlm.model.ResourceTypeValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetLifecyclePoliciesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> policyIds;
    private String state;
    private List<String> resourceTypes;
    private List<String> targetTags;
    private List<String> tagsToAdd;

    public List<String> getPolicyIds() {
        return this.policyIds;
    }

    public void setPolicyIds(Collection<String> policyIds) {
        if (policyIds == null) {
            this.policyIds = null;
            return;
        }
        this.policyIds = new ArrayList<String>(policyIds);
    }

    public GetLifecyclePoliciesRequest withPolicyIds(String ... policyIds) {
        if (this.policyIds == null) {
            this.setPolicyIds(new ArrayList<String>(policyIds.length));
        }
        for (String ele : policyIds) {
            this.policyIds.add(ele);
        }
        return this;
    }

    public GetLifecyclePoliciesRequest withPolicyIds(Collection<String> policyIds) {
        this.setPolicyIds(policyIds);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public GetLifecyclePoliciesRequest withState(String state) {
        this.setState(state);
        return this;
    }

    public GetLifecyclePoliciesRequest withState(GettablePolicyStateValues state) {
        this.state = state.toString();
        return this;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new ArrayList<String>(resourceTypes);
    }

    public GetLifecyclePoliciesRequest withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes(new ArrayList<String>(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add(ele);
        }
        return this;
    }

    public GetLifecyclePoliciesRequest withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public GetLifecyclePoliciesRequest withResourceTypes(ResourceTypeValues ... resourceTypes) {
        ArrayList<String> resourceTypesCopy = new ArrayList<String>(resourceTypes.length);
        for (ResourceTypeValues value : resourceTypes) {
            resourceTypesCopy.add(value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes(resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll(resourceTypesCopy);
        }
        return this;
    }

    public List<String> getTargetTags() {
        return this.targetTags;
    }

    public void setTargetTags(Collection<String> targetTags) {
        if (targetTags == null) {
            this.targetTags = null;
            return;
        }
        this.targetTags = new ArrayList<String>(targetTags);
    }

    public GetLifecyclePoliciesRequest withTargetTags(String ... targetTags) {
        if (this.targetTags == null) {
            this.setTargetTags(new ArrayList<String>(targetTags.length));
        }
        for (String ele : targetTags) {
            this.targetTags.add(ele);
        }
        return this;
    }

    public GetLifecyclePoliciesRequest withTargetTags(Collection<String> targetTags) {
        this.setTargetTags(targetTags);
        return this;
    }

    public List<String> getTagsToAdd() {
        return this.tagsToAdd;
    }

    public void setTagsToAdd(Collection<String> tagsToAdd) {
        if (tagsToAdd == null) {
            this.tagsToAdd = null;
            return;
        }
        this.tagsToAdd = new ArrayList<String>(tagsToAdd);
    }

    public GetLifecyclePoliciesRequest withTagsToAdd(String ... tagsToAdd) {
        if (this.tagsToAdd == null) {
            this.setTagsToAdd(new ArrayList<String>(tagsToAdd.length));
        }
        for (String ele : tagsToAdd) {
            this.tagsToAdd.add(ele);
        }
        return this;
    }

    public GetLifecyclePoliciesRequest withTagsToAdd(Collection<String> tagsToAdd) {
        this.setTagsToAdd(tagsToAdd);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyIds() != null) {
            sb.append("PolicyIds: ").append(this.getPolicyIds()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes()).append(",");
        }
        if (this.getTargetTags() != null) {
            sb.append("TargetTags: ").append(this.getTargetTags()).append(",");
        }
        if (this.getTagsToAdd() != null) {
            sb.append("TagsToAdd: ").append(this.getTagsToAdd());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePoliciesRequest)) {
            return false;
        }
        GetLifecyclePoliciesRequest other = (GetLifecyclePoliciesRequest)obj;
        if (other.getPolicyIds() == null ^ this.getPolicyIds() == null) {
            return false;
        }
        if (other.getPolicyIds() != null && !other.getPolicyIds().equals(this.getPolicyIds())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        if (other.getResourceTypes() != null && !other.getResourceTypes().equals(this.getResourceTypes())) {
            return false;
        }
        if (other.getTargetTags() == null ^ this.getTargetTags() == null) {
            return false;
        }
        if (other.getTargetTags() != null && !other.getTargetTags().equals(this.getTargetTags())) {
            return false;
        }
        if (other.getTagsToAdd() == null ^ this.getTagsToAdd() == null) {
            return false;
        }
        return other.getTagsToAdd() == null || other.getTagsToAdd().equals(this.getTagsToAdd());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyIds() == null ? 0 : this.getPolicyIds().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTags() == null ? 0 : this.getTargetTags().hashCode());
        hashCode = 31 * hashCode + (this.getTagsToAdd() == null ? 0 : this.getTagsToAdd().hashCode());
        return hashCode;
    }

    public GetLifecyclePoliciesRequest clone() {
        return (GetLifecyclePoliciesRequest)super.clone();
    }
}

