/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.LogicalOperator;
import com.amazonaws.services.deadline.model.SearchFilterExpression;
import com.amazonaws.services.deadline.model.transform.SearchGroupedFilterExpressionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchGroupedFilterExpressions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SearchFilterExpression> filters;
    private String operator;

    public List<SearchFilterExpression> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<SearchFilterExpression> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<SearchFilterExpression>(filters);
    }

    public SearchGroupedFilterExpressions withFilters(SearchFilterExpression ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<SearchFilterExpression>(filters.length));
        }
        for (SearchFilterExpression ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public SearchGroupedFilterExpressions withFilters(Collection<SearchFilterExpression> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public SearchGroupedFilterExpressions withOperator(String operator) {
        this.setOperator(operator);
        return this;
    }

    public SearchGroupedFilterExpressions withOperator(LogicalOperator operator) {
        this.operator = operator.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getOperator() != null) {
            sb.append("Operator: ").append(this.getOperator());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGroupedFilterExpressions)) {
            return false;
        }
        SearchGroupedFilterExpressions other = (SearchGroupedFilterExpressions)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getOperator() == null ^ this.getOperator() == null) {
            return false;
        }
        return other.getOperator() == null || other.getOperator().equals(this.getOperator());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getOperator() == null ? 0 : this.getOperator().hashCode());
        return hashCode;
    }

    public SearchGroupedFilterExpressions clone() {
        try {
            return (SearchGroupedFilterExpressions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SearchGroupedFilterExpressionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

