/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.PathFormat;
import com.amazonaws.services.deadline.model.transform.ManifestPropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ManifestProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String fileSystemLocationName;
    private String inputManifestHash;
    private String inputManifestPath;
    private List<String> outputRelativeDirectories;
    private String rootPath;
    private String rootPathFormat;

    public void setFileSystemLocationName(String fileSystemLocationName) {
        this.fileSystemLocationName = fileSystemLocationName;
    }

    public String getFileSystemLocationName() {
        return this.fileSystemLocationName;
    }

    public ManifestProperties withFileSystemLocationName(String fileSystemLocationName) {
        this.setFileSystemLocationName(fileSystemLocationName);
        return this;
    }

    public void setInputManifestHash(String inputManifestHash) {
        this.inputManifestHash = inputManifestHash;
    }

    public String getInputManifestHash() {
        return this.inputManifestHash;
    }

    public ManifestProperties withInputManifestHash(String inputManifestHash) {
        this.setInputManifestHash(inputManifestHash);
        return this;
    }

    public void setInputManifestPath(String inputManifestPath) {
        this.inputManifestPath = inputManifestPath;
    }

    public String getInputManifestPath() {
        return this.inputManifestPath;
    }

    public ManifestProperties withInputManifestPath(String inputManifestPath) {
        this.setInputManifestPath(inputManifestPath);
        return this;
    }

    public List<String> getOutputRelativeDirectories() {
        return this.outputRelativeDirectories;
    }

    public void setOutputRelativeDirectories(Collection<String> outputRelativeDirectories) {
        if (outputRelativeDirectories == null) {
            this.outputRelativeDirectories = null;
            return;
        }
        this.outputRelativeDirectories = new ArrayList<String>(outputRelativeDirectories);
    }

    public ManifestProperties withOutputRelativeDirectories(String ... outputRelativeDirectories) {
        if (this.outputRelativeDirectories == null) {
            this.setOutputRelativeDirectories(new ArrayList<String>(outputRelativeDirectories.length));
        }
        for (String ele : outputRelativeDirectories) {
            this.outputRelativeDirectories.add(ele);
        }
        return this;
    }

    public ManifestProperties withOutputRelativeDirectories(Collection<String> outputRelativeDirectories) {
        this.setOutputRelativeDirectories(outputRelativeDirectories);
        return this;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public ManifestProperties withRootPath(String rootPath) {
        this.setRootPath(rootPath);
        return this;
    }

    public void setRootPathFormat(String rootPathFormat) {
        this.rootPathFormat = rootPathFormat;
    }

    public String getRootPathFormat() {
        return this.rootPathFormat;
    }

    public ManifestProperties withRootPathFormat(String rootPathFormat) {
        this.setRootPathFormat(rootPathFormat);
        return this;
    }

    public ManifestProperties withRootPathFormat(PathFormat rootPathFormat) {
        this.rootPathFormat = rootPathFormat.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileSystemLocationName() != null) {
            sb.append("FileSystemLocationName: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getInputManifestHash() != null) {
            sb.append("InputManifestHash: ").append(this.getInputManifestHash()).append(",");
        }
        if (this.getInputManifestPath() != null) {
            sb.append("InputManifestPath: ").append(this.getInputManifestPath()).append(",");
        }
        if (this.getOutputRelativeDirectories() != null) {
            sb.append("OutputRelativeDirectories: ").append(this.getOutputRelativeDirectories()).append(",");
        }
        if (this.getRootPath() != null) {
            sb.append("RootPath: ").append(this.getRootPath()).append(",");
        }
        if (this.getRootPathFormat() != null) {
            sb.append("RootPathFormat: ").append(this.getRootPathFormat());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManifestProperties)) {
            return false;
        }
        ManifestProperties other = (ManifestProperties)obj;
        if (other.getFileSystemLocationName() == null ^ this.getFileSystemLocationName() == null) {
            return false;
        }
        if (other.getFileSystemLocationName() != null && !other.getFileSystemLocationName().equals(this.getFileSystemLocationName())) {
            return false;
        }
        if (other.getInputManifestHash() == null ^ this.getInputManifestHash() == null) {
            return false;
        }
        if (other.getInputManifestHash() != null && !other.getInputManifestHash().equals(this.getInputManifestHash())) {
            return false;
        }
        if (other.getInputManifestPath() == null ^ this.getInputManifestPath() == null) {
            return false;
        }
        if (other.getInputManifestPath() != null && !other.getInputManifestPath().equals(this.getInputManifestPath())) {
            return false;
        }
        if (other.getOutputRelativeDirectories() == null ^ this.getOutputRelativeDirectories() == null) {
            return false;
        }
        if (other.getOutputRelativeDirectories() != null && !other.getOutputRelativeDirectories().equals(this.getOutputRelativeDirectories())) {
            return false;
        }
        if (other.getRootPath() == null ^ this.getRootPath() == null) {
            return false;
        }
        if (other.getRootPath() != null && !other.getRootPath().equals(this.getRootPath())) {
            return false;
        }
        if (other.getRootPathFormat() == null ^ this.getRootPathFormat() == null) {
            return false;
        }
        return other.getRootPathFormat() == null || other.getRootPathFormat().equals(this.getRootPathFormat());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileSystemLocationName() == null ? 0 : this.getFileSystemLocationName().hashCode());
        hashCode = 31 * hashCode + (this.getInputManifestHash() == null ? 0 : this.getInputManifestHash().hashCode());
        hashCode = 31 * hashCode + (this.getInputManifestPath() == null ? 0 : this.getInputManifestPath().hashCode());
        hashCode = 31 * hashCode + (this.getOutputRelativeDirectories() == null ? 0 : this.getOutputRelativeDirectories().hashCode());
        hashCode = 31 * hashCode + (this.getRootPath() == null ? 0 : this.getRootPath().hashCode());
        hashCode = 31 * hashCode + (this.getRootPathFormat() == null ? 0 : this.getRootPathFormat().hashCode());
        return hashCode;
    }

    public ManifestProperties clone() {
        try {
            return (ManifestProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ManifestPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

