/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.JobMember;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListJobMembersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<JobMember> members;
    private String nextToken;

    public List<JobMember> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<JobMember> members) {
        if (members == null) {
            this.members = null;
            return;
        }
        this.members = new ArrayList<JobMember>(members);
    }

    public ListJobMembersResult withMembers(JobMember ... members) {
        if (this.members == null) {
            this.setMembers(new ArrayList<JobMember>(members.length));
        }
        for (JobMember ele : members) {
            this.members.add(ele);
        }
        return this;
    }

    public ListJobMembersResult withMembers(Collection<JobMember> members) {
        this.setMembers(members);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListJobMembersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMembers() != null) {
            sb.append("Members: ").append(this.getMembers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobMembersResult)) {
            return false;
        }
        ListJobMembersResult other = (ListJobMembersResult)obj;
        if (other.getMembers() == null ^ this.getMembers() == null) {
            return false;
        }
        if (other.getMembers() != null && !other.getMembers().equals(this.getMembers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMembers() == null ? 0 : this.getMembers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListJobMembersResult clone() {
        try {
            return (ListJobMembersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

