/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.deadline.model.FileSystemLocation;
import com.amazonaws.services.deadline.model.StorageProfileOperatingSystemFamily;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateStorageProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String displayName;
    private String farmId;
    private List<FileSystemLocation> fileSystemLocations;
    private String osFamily;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateStorageProfileRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateStorageProfileRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setFarmId(String farmId) {
        this.farmId = farmId;
    }

    public String getFarmId() {
        return this.farmId;
    }

    public CreateStorageProfileRequest withFarmId(String farmId) {
        this.setFarmId(farmId);
        return this;
    }

    public List<FileSystemLocation> getFileSystemLocations() {
        return this.fileSystemLocations;
    }

    public void setFileSystemLocations(Collection<FileSystemLocation> fileSystemLocations) {
        if (fileSystemLocations == null) {
            this.fileSystemLocations = null;
            return;
        }
        this.fileSystemLocations = new ArrayList<FileSystemLocation>(fileSystemLocations);
    }

    public CreateStorageProfileRequest withFileSystemLocations(FileSystemLocation ... fileSystemLocations) {
        if (this.fileSystemLocations == null) {
            this.setFileSystemLocations(new ArrayList<FileSystemLocation>(fileSystemLocations.length));
        }
        for (FileSystemLocation ele : fileSystemLocations) {
            this.fileSystemLocations.add(ele);
        }
        return this;
    }

    public CreateStorageProfileRequest withFileSystemLocations(Collection<FileSystemLocation> fileSystemLocations) {
        this.setFileSystemLocations(fileSystemLocations);
        return this;
    }

    public void setOsFamily(String osFamily) {
        this.osFamily = osFamily;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public CreateStorageProfileRequest withOsFamily(String osFamily) {
        this.setOsFamily(osFamily);
        return this;
    }

    public CreateStorageProfileRequest withOsFamily(StorageProfileOperatingSystemFamily osFamily) {
        this.osFamily = osFamily.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getFarmId() != null) {
            sb.append("FarmId: ").append(this.getFarmId()).append(",");
        }
        if (this.getFileSystemLocations() != null) {
            sb.append("FileSystemLocations: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOsFamily() != null) {
            sb.append("OsFamily: ").append(this.getOsFamily());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorageProfileRequest)) {
            return false;
        }
        CreateStorageProfileRequest other = (CreateStorageProfileRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getFarmId() == null ^ this.getFarmId() == null) {
            return false;
        }
        if (other.getFarmId() != null && !other.getFarmId().equals(this.getFarmId())) {
            return false;
        }
        if (other.getFileSystemLocations() == null ^ this.getFileSystemLocations() == null) {
            return false;
        }
        if (other.getFileSystemLocations() != null && !other.getFileSystemLocations().equals(this.getFileSystemLocations())) {
            return false;
        }
        if (other.getOsFamily() == null ^ this.getOsFamily() == null) {
            return false;
        }
        return other.getOsFamily() == null || other.getOsFamily().equals(this.getOsFamily());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getFarmId() == null ? 0 : this.getFarmId().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemLocations() == null ? 0 : this.getFileSystemLocations().hashCode());
        hashCode = 31 * hashCode + (this.getOsFamily() == null ? 0 : this.getOsFamily().hashCode());
        return hashCode;
    }

    public CreateStorageProfileRequest clone() {
        return (CreateStorageProfileRequest)super.clone();
    }
}

