/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.datazone.model.SearchResultItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchListingsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SearchResultItem> items;
    private String nextToken;
    private Integer totalMatchCount;

    public List<SearchResultItem> getItems() {
        return this.items;
    }

    public void setItems(Collection<SearchResultItem> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new ArrayList<SearchResultItem>(items);
    }

    public SearchListingsResult withItems(SearchResultItem ... items) {
        if (this.items == null) {
            this.setItems(new ArrayList<SearchResultItem>(items.length));
        }
        for (SearchResultItem ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public SearchListingsResult withItems(Collection<SearchResultItem> items) {
        this.setItems(items);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchListingsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setTotalMatchCount(Integer totalMatchCount) {
        this.totalMatchCount = totalMatchCount;
    }

    public Integer getTotalMatchCount() {
        return this.totalMatchCount;
    }

    public SearchListingsResult withTotalMatchCount(Integer totalMatchCount) {
        this.setTotalMatchCount(totalMatchCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getTotalMatchCount() != null) {
            sb.append("TotalMatchCount: ").append(this.getTotalMatchCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchListingsResult)) {
            return false;
        }
        SearchListingsResult other = (SearchListingsResult)obj;
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getTotalMatchCount() == null ^ this.getTotalMatchCount() == null) {
            return false;
        }
        return other.getTotalMatchCount() == null || other.getTotalMatchCount().equals(this.getTotalMatchCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getTotalMatchCount() == null ? 0 : this.getTotalMatchCount().hashCode());
        return hashCode;
    }

    public SearchListingsResult clone() {
        try {
            return (SearchListingsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

