/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.Ec2Config;
import com.amazonaws.services.datasync.model.EfsInTransitEncryption;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateLocationEfsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String subdirectory;
    private String efsFilesystemArn;
    private Ec2Config ec2Config;
    private List<TagListEntry> tags;
    private String accessPointArn;
    private String fileSystemAccessRoleArn;
    private String inTransitEncryption;

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public CreateLocationEfsRequest withSubdirectory(String subdirectory) {
        this.setSubdirectory(subdirectory);
        return this;
    }

    public void setEfsFilesystemArn(String efsFilesystemArn) {
        this.efsFilesystemArn = efsFilesystemArn;
    }

    public String getEfsFilesystemArn() {
        return this.efsFilesystemArn;
    }

    public CreateLocationEfsRequest withEfsFilesystemArn(String efsFilesystemArn) {
        this.setEfsFilesystemArn(efsFilesystemArn);
        return this;
    }

    public void setEc2Config(Ec2Config ec2Config) {
        this.ec2Config = ec2Config;
    }

    public Ec2Config getEc2Config() {
        return this.ec2Config;
    }

    public CreateLocationEfsRequest withEc2Config(Ec2Config ec2Config) {
        this.setEc2Config(ec2Config);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public CreateLocationEfsRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateLocationEfsRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public void setAccessPointArn(String accessPointArn) {
        this.accessPointArn = accessPointArn;
    }

    public String getAccessPointArn() {
        return this.accessPointArn;
    }

    public CreateLocationEfsRequest withAccessPointArn(String accessPointArn) {
        this.setAccessPointArn(accessPointArn);
        return this;
    }

    public void setFileSystemAccessRoleArn(String fileSystemAccessRoleArn) {
        this.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
    }

    public String getFileSystemAccessRoleArn() {
        return this.fileSystemAccessRoleArn;
    }

    public CreateLocationEfsRequest withFileSystemAccessRoleArn(String fileSystemAccessRoleArn) {
        this.setFileSystemAccessRoleArn(fileSystemAccessRoleArn);
        return this;
    }

    public void setInTransitEncryption(String inTransitEncryption) {
        this.inTransitEncryption = inTransitEncryption;
    }

    public String getInTransitEncryption() {
        return this.inTransitEncryption;
    }

    public CreateLocationEfsRequest withInTransitEncryption(String inTransitEncryption) {
        this.setInTransitEncryption(inTransitEncryption);
        return this;
    }

    public CreateLocationEfsRequest withInTransitEncryption(EfsInTransitEncryption inTransitEncryption) {
        this.inTransitEncryption = inTransitEncryption.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubdirectory() != null) {
            sb.append("Subdirectory: ").append(this.getSubdirectory()).append(",");
        }
        if (this.getEfsFilesystemArn() != null) {
            sb.append("EfsFilesystemArn: ").append(this.getEfsFilesystemArn()).append(",");
        }
        if (this.getEc2Config() != null) {
            sb.append("Ec2Config: ").append(this.getEc2Config()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAccessPointArn() != null) {
            sb.append("AccessPointArn: ").append(this.getAccessPointArn()).append(",");
        }
        if (this.getFileSystemAccessRoleArn() != null) {
            sb.append("FileSystemAccessRoleArn: ").append(this.getFileSystemAccessRoleArn()).append(",");
        }
        if (this.getInTransitEncryption() != null) {
            sb.append("InTransitEncryption: ").append(this.getInTransitEncryption());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationEfsRequest)) {
            return false;
        }
        CreateLocationEfsRequest other = (CreateLocationEfsRequest)obj;
        if (other.getSubdirectory() == null ^ this.getSubdirectory() == null) {
            return false;
        }
        if (other.getSubdirectory() != null && !other.getSubdirectory().equals(this.getSubdirectory())) {
            return false;
        }
        if (other.getEfsFilesystemArn() == null ^ this.getEfsFilesystemArn() == null) {
            return false;
        }
        if (other.getEfsFilesystemArn() != null && !other.getEfsFilesystemArn().equals(this.getEfsFilesystemArn())) {
            return false;
        }
        if (other.getEc2Config() == null ^ this.getEc2Config() == null) {
            return false;
        }
        if (other.getEc2Config() != null && !other.getEc2Config().equals(this.getEc2Config())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAccessPointArn() == null ^ this.getAccessPointArn() == null) {
            return false;
        }
        if (other.getAccessPointArn() != null && !other.getAccessPointArn().equals(this.getAccessPointArn())) {
            return false;
        }
        if (other.getFileSystemAccessRoleArn() == null ^ this.getFileSystemAccessRoleArn() == null) {
            return false;
        }
        if (other.getFileSystemAccessRoleArn() != null && !other.getFileSystemAccessRoleArn().equals(this.getFileSystemAccessRoleArn())) {
            return false;
        }
        if (other.getInTransitEncryption() == null ^ this.getInTransitEncryption() == null) {
            return false;
        }
        return other.getInTransitEncryption() == null || other.getInTransitEncryption().equals(this.getInTransitEncryption());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubdirectory() == null ? 0 : this.getSubdirectory().hashCode());
        hashCode = 31 * hashCode + (this.getEfsFilesystemArn() == null ? 0 : this.getEfsFilesystemArn().hashCode());
        hashCode = 31 * hashCode + (this.getEc2Config() == null ? 0 : this.getEc2Config().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAccessPointArn() == null ? 0 : this.getAccessPointArn().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemAccessRoleArn() == null ? 0 : this.getFileSystemAccessRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getInTransitEncryption() == null ? 0 : this.getInTransitEncryption().hashCode());
        return hashCode;
    }

    public CreateLocationEfsRequest clone() {
        return (CreateLocationEfsRequest)super.clone();
    }
}

