/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datasync.model.LocationFilterName;
import com.amazonaws.services.datasync.model.Operator;
import com.amazonaws.services.datasync.model.transform.LocationFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LocationFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> values;
    private String operator;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LocationFilter withName(String name) {
        this.setName(name);
        return this;
    }

    public LocationFilter withName(LocationFilterName name) {
        this.name = name.toString();
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<String>(values);
    }

    public LocationFilter withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public LocationFilter withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public LocationFilter withOperator(String operator) {
        this.setOperator(operator);
        return this;
    }

    public LocationFilter withOperator(Operator operator) {
        this.operator = operator.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues()).append(",");
        }
        if (this.getOperator() != null) {
            sb.append("Operator: ").append(this.getOperator());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationFilter)) {
            return false;
        }
        LocationFilter other = (LocationFilter)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        if (other.getValues() != null && !other.getValues().equals(this.getValues())) {
            return false;
        }
        if (other.getOperator() == null ^ this.getOperator() == null) {
            return false;
        }
        return other.getOperator() == null || other.getOperator().equals(this.getOperator());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        hashCode = 31 * hashCode + (this.getOperator() == null ? 0 : this.getOperator().hashCode());
        return hashCode;
    }

    public LocationFilter clone() {
        try {
            return (LocationFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocationFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

