/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.ParameterValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ActivatePipelineRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String pipelineId;
    private ListWithAutoConstructFlag<ParameterValue> parameterValues;
    private Date startTimestamp;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public ActivatePipelineRequest withPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public List<ParameterValue> getParameterValues() {
        if (this.parameterValues == null) {
            this.parameterValues = new ListWithAutoConstructFlag();
            this.parameterValues.setAutoConstruct(true);
        }
        return this.parameterValues;
    }

    public void setParameterValues(Collection<ParameterValue> parameterValues) {
        if (parameterValues == null) {
            this.parameterValues = null;
            return;
        }
        ListWithAutoConstructFlag parameterValuesCopy = new ListWithAutoConstructFlag(parameterValues.size());
        parameterValuesCopy.addAll(parameterValues);
        this.parameterValues = parameterValuesCopy;
    }

    public ActivatePipelineRequest withParameterValues(ParameterValue ... parameterValues) {
        if (this.getParameterValues() == null) {
            this.setParameterValues(new ArrayList<ParameterValue>(parameterValues.length));
        }
        for (ParameterValue value : parameterValues) {
            this.getParameterValues().add(value);
        }
        return this;
    }

    public ActivatePipelineRequest withParameterValues(Collection<ParameterValue> parameterValues) {
        if (parameterValues == null) {
            this.parameterValues = null;
        } else {
            ListWithAutoConstructFlag parameterValuesCopy = new ListWithAutoConstructFlag(parameterValues.size());
            parameterValuesCopy.addAll(parameterValues);
            this.parameterValues = parameterValuesCopy;
        }
        return this;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public ActivatePipelineRequest withStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getParameterValues() != null) {
            sb.append("ParameterValues: " + this.getParameterValues() + ",");
        }
        if (this.getStartTimestamp() != null) {
            sb.append("StartTimestamp: " + this.getStartTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getParameterValues() == null ? 0 : this.getParameterValues().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimestamp() == null ? 0 : this.getStartTimestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivatePipelineRequest)) {
            return false;
        }
        ActivatePipelineRequest other = (ActivatePipelineRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getParameterValues() == null ^ this.getParameterValues() == null) {
            return false;
        }
        if (other.getParameterValues() != null && !other.getParameterValues().equals(this.getParameterValues())) {
            return false;
        }
        if (other.getStartTimestamp() == null ^ this.getStartTimestamp() == null) {
            return false;
        }
        return other.getStartTimestamp() == null || other.getStartTimestamp().equals(this.getStartTimestamp());
    }

    public ActivatePipelineRequest clone() {
        return (ActivatePipelineRequest)super.clone();
    }
}

