/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dataexchange.model.DatabaseLFTagPolicyPermission;
import com.amazonaws.services.dataexchange.model.LFTag;
import com.amazonaws.services.dataexchange.model.transform.DatabaseLFTagPolicyAndPermissionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DatabaseLFTagPolicyAndPermissions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<LFTag> expression;
    private List<String> permissions;

    public List<LFTag> getExpression() {
        return this.expression;
    }

    public void setExpression(Collection<LFTag> expression) {
        if (expression == null) {
            this.expression = null;
            return;
        }
        this.expression = new ArrayList<LFTag>(expression);
    }

    public DatabaseLFTagPolicyAndPermissions withExpression(LFTag ... expression) {
        if (this.expression == null) {
            this.setExpression(new ArrayList<LFTag>(expression.length));
        }
        for (LFTag ele : expression) {
            this.expression.add(ele);
        }
        return this;
    }

    public DatabaseLFTagPolicyAndPermissions withExpression(Collection<LFTag> expression) {
        this.setExpression(expression);
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<String>(permissions);
    }

    public DatabaseLFTagPolicyAndPermissions withPermissions(String ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public DatabaseLFTagPolicyAndPermissions withPermissions(Collection<String> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public DatabaseLFTagPolicyAndPermissions withPermissions(DatabaseLFTagPolicyPermission ... permissions) {
        ArrayList<String> permissionsCopy = new ArrayList<String>(permissions.length);
        for (DatabaseLFTagPolicyPermission value : permissions) {
            permissionsCopy.add(value.toString());
        }
        if (this.getPermissions() == null) {
            this.setPermissions(permissionsCopy);
        } else {
            this.getPermissions().addAll(permissionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExpression() != null) {
            sb.append("Expression: ").append(this.getExpression()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseLFTagPolicyAndPermissions)) {
            return false;
        }
        DatabaseLFTagPolicyAndPermissions other = (DatabaseLFTagPolicyAndPermissions)obj;
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        if (other.getExpression() != null && !other.getExpression().equals(this.getExpression())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        return other.getPermissions() == null || other.getPermissions().equals(this.getPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        return hashCode;
    }

    public DatabaseLFTagPolicyAndPermissions clone() {
        try {
            return (DatabaseLFTagPolicyAndPermissions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatabaseLFTagPolicyAndPermissionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

