/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.controltower.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.controltower.model.BaselineOperation;
import java.util.Date;

@SdkInternalApi
public class BaselineOperationMarshaller {
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> OPERATIONIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationIdentifier").build();
    private static final MarshallingInfo<String> OPERATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationType").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusMessage").build();
    private static final BaselineOperationMarshaller instance = new BaselineOperationMarshaller();

    public static BaselineOperationMarshaller getInstance() {
        return instance;
    }

    public void marshall(BaselineOperation baselineOperation, ProtocolMarshaller protocolMarshaller) {
        if (baselineOperation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)baselineOperation.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)baselineOperation.getOperationIdentifier(), OPERATIONIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)baselineOperation.getOperationType(), OPERATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)baselineOperation.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)baselineOperation.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)baselineOperation.getStatusMessage(), STATUSMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

