/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.controlcatalog.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.controlcatalog.model.ObjectiveSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListObjectivesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ObjectiveSummary> objectives;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListObjectivesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ObjectiveSummary> getObjectives() {
        return this.objectives;
    }

    public void setObjectives(Collection<ObjectiveSummary> objectives) {
        if (objectives == null) {
            this.objectives = null;
            return;
        }
        this.objectives = new ArrayList<ObjectiveSummary>(objectives);
    }

    public ListObjectivesResult withObjectives(ObjectiveSummary ... objectives) {
        if (this.objectives == null) {
            this.setObjectives(new ArrayList<ObjectiveSummary>(objectives.length));
        }
        for (ObjectiveSummary ele : objectives) {
            this.objectives.add(ele);
        }
        return this;
    }

    public ListObjectivesResult withObjectives(Collection<ObjectiveSummary> objectives) {
        this.setObjectives(objectives);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getObjectives() != null) {
            sb.append("Objectives: ").append(this.getObjectives());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectivesResult)) {
            return false;
        }
        ListObjectivesResult other = (ListObjectivesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getObjectives() == null ^ this.getObjectives() == null) {
            return false;
        }
        return other.getObjectives() == null || other.getObjectives().equals(this.getObjectives());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getObjectives() == null ? 0 : this.getObjectives().hashCode());
        return hashCode;
    }

    public ListObjectivesResult clone() {
        try {
            return (ListObjectivesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

