/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectcases.model.AuditEvent;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AuditEventMarshaller {
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventId").build();
    private static final MarshallingInfo<List> FIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fields").build();
    private static final MarshallingInfo<StructuredPojo> PERFORMEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("performedBy").build();
    private static final MarshallingInfo<Date> PERFORMEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("performedTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> RELATEDITEMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedItemType").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final AuditEventMarshaller instance = new AuditEventMarshaller();

    public static AuditEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(AuditEvent auditEvent, ProtocolMarshaller protocolMarshaller) {
        if (auditEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)auditEvent.getEventId(), EVENTID_BINDING);
            protocolMarshaller.marshall(auditEvent.getFields(), FIELDS_BINDING);
            protocolMarshaller.marshall((Object)auditEvent.getPerformedBy(), PERFORMEDBY_BINDING);
            protocolMarshaller.marshall((Object)auditEvent.getPerformedTime(), PERFORMEDTIME_BINDING);
            protocolMarshaller.marshall((Object)auditEvent.getRelatedItemType(), RELATEDITEMTYPE_BINDING);
            protocolMarshaller.marshall((Object)auditEvent.getType(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

