/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connectcases.model.FieldValue;
import com.amazonaws.services.connectcases.model.UserUnion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateCaseRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String caseId;
    private String domainId;
    private List<FieldValue> fields;
    private UserUnion performedBy;

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public UpdateCaseRequest withCaseId(String caseId) {
        this.setCaseId(caseId);
        return this;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public UpdateCaseRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public List<FieldValue> getFields() {
        return this.fields;
    }

    public void setFields(Collection<FieldValue> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new ArrayList<FieldValue>(fields);
    }

    public UpdateCaseRequest withFields(FieldValue ... fields) {
        if (this.fields == null) {
            this.setFields(new ArrayList<FieldValue>(fields.length));
        }
        for (FieldValue ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public UpdateCaseRequest withFields(Collection<FieldValue> fields) {
        this.setFields(fields);
        return this;
    }

    public void setPerformedBy(UserUnion performedBy) {
        this.performedBy = performedBy;
    }

    public UserUnion getPerformedBy() {
        return this.performedBy;
    }

    public UpdateCaseRequest withPerformedBy(UserUnion performedBy) {
        this.setPerformedBy(performedBy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCaseId() != null) {
            sb.append("CaseId: ").append(this.getCaseId()).append(",");
        }
        if (this.getDomainId() != null) {
            sb.append("DomainId: ").append(this.getDomainId()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields()).append(",");
        }
        if (this.getPerformedBy() != null) {
            sb.append("PerformedBy: ").append(this.getPerformedBy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCaseRequest)) {
            return false;
        }
        UpdateCaseRequest other = (UpdateCaseRequest)obj;
        if (other.getCaseId() == null ^ this.getCaseId() == null) {
            return false;
        }
        if (other.getCaseId() != null && !other.getCaseId().equals(this.getCaseId())) {
            return false;
        }
        if (other.getDomainId() == null ^ this.getDomainId() == null) {
            return false;
        }
        if (other.getDomainId() != null && !other.getDomainId().equals(this.getDomainId())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        if (other.getFields() != null && !other.getFields().equals(this.getFields())) {
            return false;
        }
        if (other.getPerformedBy() == null ^ this.getPerformedBy() == null) {
            return false;
        }
        return other.getPerformedBy() == null || other.getPerformedBy().equals(this.getPerformedBy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCaseId() == null ? 0 : this.getCaseId().hashCode());
        hashCode = 31 * hashCode + (this.getDomainId() == null ? 0 : this.getDomainId().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        hashCode = 31 * hashCode + (this.getPerformedBy() == null ? 0 : this.getPerformedBy().hashCode());
        return hashCode;
    }

    public UpdateCaseRequest clone() {
        return (UpdateCaseRequest)super.clone();
    }
}

