/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connectcases.model.RelatedItemTypeFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchRelatedItemsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String caseId;
    private String domainId;
    private List<RelatedItemTypeFilter> filters;
    private Integer maxResults;
    private String nextToken;

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public SearchRelatedItemsRequest withCaseId(String caseId) {
        this.setCaseId(caseId);
        return this;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public SearchRelatedItemsRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public List<RelatedItemTypeFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<RelatedItemTypeFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<RelatedItemTypeFilter>(filters);
    }

    public SearchRelatedItemsRequest withFilters(RelatedItemTypeFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<RelatedItemTypeFilter>(filters.length));
        }
        for (RelatedItemTypeFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public SearchRelatedItemsRequest withFilters(Collection<RelatedItemTypeFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public SearchRelatedItemsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchRelatedItemsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCaseId() != null) {
            sb.append("CaseId: ").append(this.getCaseId()).append(",");
        }
        if (this.getDomainId() != null) {
            sb.append("DomainId: ").append(this.getDomainId()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRelatedItemsRequest)) {
            return false;
        }
        SearchRelatedItemsRequest other = (SearchRelatedItemsRequest)obj;
        if (other.getCaseId() == null ^ this.getCaseId() == null) {
            return false;
        }
        if (other.getCaseId() != null && !other.getCaseId().equals(this.getCaseId())) {
            return false;
        }
        if (other.getDomainId() == null ^ this.getDomainId() == null) {
            return false;
        }
        if (other.getDomainId() != null && !other.getDomainId().equals(this.getDomainId())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCaseId() == null ? 0 : this.getCaseId().hashCode());
        hashCode = 31 * hashCode + (this.getDomainId() == null ? 0 : this.getDomainId().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public SearchRelatedItemsRequest clone() {
        return (SearchRelatedItemsRequest)super.clone();
    }
}

