/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.transform.UploadUrlMetadataMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UploadUrlMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String url;
    private String urlExpiry;
    private Map<String, String> headersToInclude;

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public UploadUrlMetadata withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public void setUrlExpiry(String urlExpiry) {
        this.urlExpiry = urlExpiry;
    }

    public String getUrlExpiry() {
        return this.urlExpiry;
    }

    public UploadUrlMetadata withUrlExpiry(String urlExpiry) {
        this.setUrlExpiry(urlExpiry);
        return this;
    }

    public Map<String, String> getHeadersToInclude() {
        return this.headersToInclude;
    }

    public void setHeadersToInclude(Map<String, String> headersToInclude) {
        this.headersToInclude = headersToInclude;
    }

    public UploadUrlMetadata withHeadersToInclude(Map<String, String> headersToInclude) {
        this.setHeadersToInclude(headersToInclude);
        return this;
    }

    public UploadUrlMetadata addHeadersToIncludeEntry(String key, String value) {
        if (null == this.headersToInclude) {
            this.headersToInclude = new HashMap<String, String>();
        }
        if (this.headersToInclude.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.headersToInclude.put(key, value);
        return this;
    }

    public UploadUrlMetadata clearHeadersToIncludeEntries() {
        this.headersToInclude = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl()).append(",");
        }
        if (this.getUrlExpiry() != null) {
            sb.append("UrlExpiry: ").append(this.getUrlExpiry()).append(",");
        }
        if (this.getHeadersToInclude() != null) {
            sb.append("HeadersToInclude: ").append(this.getHeadersToInclude());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadUrlMetadata)) {
            return false;
        }
        UploadUrlMetadata other = (UploadUrlMetadata)obj;
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        if (other.getUrl() != null && !other.getUrl().equals(this.getUrl())) {
            return false;
        }
        if (other.getUrlExpiry() == null ^ this.getUrlExpiry() == null) {
            return false;
        }
        if (other.getUrlExpiry() != null && !other.getUrlExpiry().equals(this.getUrlExpiry())) {
            return false;
        }
        if (other.getHeadersToInclude() == null ^ this.getHeadersToInclude() == null) {
            return false;
        }
        return other.getHeadersToInclude() == null || other.getHeadersToInclude().equals(this.getHeadersToInclude());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        hashCode = 31 * hashCode + (this.getUrlExpiry() == null ? 0 : this.getUrlExpiry().hashCode());
        hashCode = 31 * hashCode + (this.getHeadersToInclude() == null ? 0 : this.getHeadersToInclude().hashCode());
        return hashCode;
    }

    public UploadUrlMetadata clone() {
        try {
            return (UploadUrlMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UploadUrlMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

