/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.PhoneNumberCountryCode;
import com.amazonaws.services.connect.model.PhoneNumberType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPhoneNumbersRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private List<String> phoneNumberTypes;
    private List<String> phoneNumberCountryCodes;
    private String nextToken;
    private Integer maxResults;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ListPhoneNumbersRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public List<String> getPhoneNumberTypes() {
        return this.phoneNumberTypes;
    }

    public void setPhoneNumberTypes(Collection<String> phoneNumberTypes) {
        if (phoneNumberTypes == null) {
            this.phoneNumberTypes = null;
            return;
        }
        this.phoneNumberTypes = new ArrayList<String>(phoneNumberTypes);
    }

    public ListPhoneNumbersRequest withPhoneNumberTypes(String ... phoneNumberTypes) {
        if (this.phoneNumberTypes == null) {
            this.setPhoneNumberTypes(new ArrayList<String>(phoneNumberTypes.length));
        }
        for (String ele : phoneNumberTypes) {
            this.phoneNumberTypes.add(ele);
        }
        return this;
    }

    public ListPhoneNumbersRequest withPhoneNumberTypes(Collection<String> phoneNumberTypes) {
        this.setPhoneNumberTypes(phoneNumberTypes);
        return this;
    }

    public ListPhoneNumbersRequest withPhoneNumberTypes(PhoneNumberType ... phoneNumberTypes) {
        ArrayList<String> phoneNumberTypesCopy = new ArrayList<String>(phoneNumberTypes.length);
        for (PhoneNumberType value : phoneNumberTypes) {
            phoneNumberTypesCopy.add(value.toString());
        }
        if (this.getPhoneNumberTypes() == null) {
            this.setPhoneNumberTypes(phoneNumberTypesCopy);
        } else {
            this.getPhoneNumberTypes().addAll(phoneNumberTypesCopy);
        }
        return this;
    }

    public List<String> getPhoneNumberCountryCodes() {
        return this.phoneNumberCountryCodes;
    }

    public void setPhoneNumberCountryCodes(Collection<String> phoneNumberCountryCodes) {
        if (phoneNumberCountryCodes == null) {
            this.phoneNumberCountryCodes = null;
            return;
        }
        this.phoneNumberCountryCodes = new ArrayList<String>(phoneNumberCountryCodes);
    }

    public ListPhoneNumbersRequest withPhoneNumberCountryCodes(String ... phoneNumberCountryCodes) {
        if (this.phoneNumberCountryCodes == null) {
            this.setPhoneNumberCountryCodes(new ArrayList<String>(phoneNumberCountryCodes.length));
        }
        for (String ele : phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes.add(ele);
        }
        return this;
    }

    public ListPhoneNumbersRequest withPhoneNumberCountryCodes(Collection<String> phoneNumberCountryCodes) {
        this.setPhoneNumberCountryCodes(phoneNumberCountryCodes);
        return this;
    }

    public ListPhoneNumbersRequest withPhoneNumberCountryCodes(PhoneNumberCountryCode ... phoneNumberCountryCodes) {
        ArrayList<String> phoneNumberCountryCodesCopy = new ArrayList<String>(phoneNumberCountryCodes.length);
        for (PhoneNumberCountryCode value : phoneNumberCountryCodes) {
            phoneNumberCountryCodesCopy.add(value.toString());
        }
        if (this.getPhoneNumberCountryCodes() == null) {
            this.setPhoneNumberCountryCodes(phoneNumberCountryCodesCopy);
        } else {
            this.getPhoneNumberCountryCodes().addAll(phoneNumberCountryCodesCopy);
        }
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPhoneNumbersRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListPhoneNumbersRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getPhoneNumberTypes() != null) {
            sb.append("PhoneNumberTypes: ").append(this.getPhoneNumberTypes()).append(",");
        }
        if (this.getPhoneNumberCountryCodes() != null) {
            sb.append("PhoneNumberCountryCodes: ").append(this.getPhoneNumberCountryCodes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersRequest)) {
            return false;
        }
        ListPhoneNumbersRequest other = (ListPhoneNumbersRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getPhoneNumberTypes() == null ^ this.getPhoneNumberTypes() == null) {
            return false;
        }
        if (other.getPhoneNumberTypes() != null && !other.getPhoneNumberTypes().equals(this.getPhoneNumberTypes())) {
            return false;
        }
        if (other.getPhoneNumberCountryCodes() == null ^ this.getPhoneNumberCountryCodes() == null) {
            return false;
        }
        if (other.getPhoneNumberCountryCodes() != null && !other.getPhoneNumberCountryCodes().equals(this.getPhoneNumberCountryCodes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneNumberTypes() == null ? 0 : this.getPhoneNumberTypes().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneNumberCountryCodes() == null ? 0 : this.getPhoneNumberCountryCodes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public ListPhoneNumbersRequest clone() {
        return (ListPhoneNumbersRequest)super.clone();
    }
}

