/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.transform.PromptMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Prompt
implements Serializable,
Cloneable,
StructuredPojo {
    private String promptARN;
    private String promptId;
    private String name;
    private String description;
    private Map<String, String> tags;

    public void setPromptARN(String promptARN) {
        this.promptARN = promptARN;
    }

    public String getPromptARN() {
        return this.promptARN;
    }

    public Prompt withPromptARN(String promptARN) {
        this.setPromptARN(promptARN);
        return this;
    }

    public void setPromptId(String promptId) {
        this.promptId = promptId;
    }

    public String getPromptId() {
        return this.promptId;
    }

    public Prompt withPromptId(String promptId) {
        this.setPromptId(promptId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Prompt withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Prompt withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Prompt withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Prompt addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Prompt clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPromptARN() != null) {
            sb.append("PromptARN: ").append(this.getPromptARN()).append(",");
        }
        if (this.getPromptId() != null) {
            sb.append("PromptId: ").append(this.getPromptId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prompt)) {
            return false;
        }
        Prompt other = (Prompt)obj;
        if (other.getPromptARN() == null ^ this.getPromptARN() == null) {
            return false;
        }
        if (other.getPromptARN() != null && !other.getPromptARN().equals(this.getPromptARN())) {
            return false;
        }
        if (other.getPromptId() == null ^ this.getPromptId() == null) {
            return false;
        }
        if (other.getPromptId() != null && !other.getPromptId().equals(this.getPromptId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPromptARN() == null ? 0 : this.getPromptARN().hashCode());
        hashCode = 31 * hashCode + (this.getPromptId() == null ? 0 : this.getPromptId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Prompt clone() {
        try {
            return (Prompt)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PromptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

