/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.DocumentClassificationConfig;
import com.amazonaws.services.comprehend.model.EntityRecognitionConfig;
import com.amazonaws.services.comprehend.model.LanguageCode;
import com.amazonaws.services.comprehend.model.transform.TaskConfigMarshaller;
import java.io.Serializable;

public class TaskConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String languageCode;
    private DocumentClassificationConfig documentClassificationConfig;
    private EntityRecognitionConfig entityRecognitionConfig;

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public TaskConfig withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public TaskConfig withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public void setDocumentClassificationConfig(DocumentClassificationConfig documentClassificationConfig) {
        this.documentClassificationConfig = documentClassificationConfig;
    }

    public DocumentClassificationConfig getDocumentClassificationConfig() {
        return this.documentClassificationConfig;
    }

    public TaskConfig withDocumentClassificationConfig(DocumentClassificationConfig documentClassificationConfig) {
        this.setDocumentClassificationConfig(documentClassificationConfig);
        return this;
    }

    public void setEntityRecognitionConfig(EntityRecognitionConfig entityRecognitionConfig) {
        this.entityRecognitionConfig = entityRecognitionConfig;
    }

    public EntityRecognitionConfig getEntityRecognitionConfig() {
        return this.entityRecognitionConfig;
    }

    public TaskConfig withEntityRecognitionConfig(EntityRecognitionConfig entityRecognitionConfig) {
        this.setEntityRecognitionConfig(entityRecognitionConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getDocumentClassificationConfig() != null) {
            sb.append("DocumentClassificationConfig: ").append(this.getDocumentClassificationConfig()).append(",");
        }
        if (this.getEntityRecognitionConfig() != null) {
            sb.append("EntityRecognitionConfig: ").append(this.getEntityRecognitionConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskConfig)) {
            return false;
        }
        TaskConfig other = (TaskConfig)obj;
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getDocumentClassificationConfig() == null ^ this.getDocumentClassificationConfig() == null) {
            return false;
        }
        if (other.getDocumentClassificationConfig() != null && !other.getDocumentClassificationConfig().equals(this.getDocumentClassificationConfig())) {
            return false;
        }
        if (other.getEntityRecognitionConfig() == null ^ this.getEntityRecognitionConfig() == null) {
            return false;
        }
        return other.getEntityRecognitionConfig() == null || other.getEntityRecognitionConfig().equals(this.getEntityRecognitionConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentClassificationConfig() == null ? 0 : this.getDocumentClassificationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEntityRecognitionConfig() == null ? 0 : this.getEntityRecognitionConfig().hashCode());
        return hashCode;
    }

    public TaskConfig clone() {
        try {
            return (TaskConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

