/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.comprehend.model.DocumentReaderConfig;
import com.amazonaws.services.comprehend.model.LanguageCode;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class DetectEntitiesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String text;
    private String languageCode;
    private String endpointArn;
    private ByteBuffer bytes;
    private DocumentReaderConfig documentReaderConfig;

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public DetectEntitiesRequest withText(String text) {
        this.setText(text);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public DetectEntitiesRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public DetectEntitiesRequest withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public void setEndpointArn(String endpointArn) {
        this.endpointArn = endpointArn;
    }

    public String getEndpointArn() {
        return this.endpointArn;
    }

    public DetectEntitiesRequest withEndpointArn(String endpointArn) {
        this.setEndpointArn(endpointArn);
        return this;
    }

    public void setBytes(ByteBuffer bytes) {
        this.bytes = bytes;
    }

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public DetectEntitiesRequest withBytes(ByteBuffer bytes) {
        this.setBytes(bytes);
        return this;
    }

    public void setDocumentReaderConfig(DocumentReaderConfig documentReaderConfig) {
        this.documentReaderConfig = documentReaderConfig;
    }

    public DocumentReaderConfig getDocumentReaderConfig() {
        return this.documentReaderConfig;
    }

    public DetectEntitiesRequest withDocumentReaderConfig(DocumentReaderConfig documentReaderConfig) {
        this.setDocumentReaderConfig(documentReaderConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getText() != null) {
            sb.append("Text: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getEndpointArn() != null) {
            sb.append("EndpointArn: ").append(this.getEndpointArn()).append(",");
        }
        if (this.getBytes() != null) {
            sb.append("Bytes: ").append(this.getBytes()).append(",");
        }
        if (this.getDocumentReaderConfig() != null) {
            sb.append("DocumentReaderConfig: ").append(this.getDocumentReaderConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesRequest)) {
            return false;
        }
        DetectEntitiesRequest other = (DetectEntitiesRequest)obj;
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getEndpointArn() == null ^ this.getEndpointArn() == null) {
            return false;
        }
        if (other.getEndpointArn() != null && !other.getEndpointArn().equals(this.getEndpointArn())) {
            return false;
        }
        if (other.getBytes() == null ^ this.getBytes() == null) {
            return false;
        }
        if (other.getBytes() != null && !other.getBytes().equals(this.getBytes())) {
            return false;
        }
        if (other.getDocumentReaderConfig() == null ^ this.getDocumentReaderConfig() == null) {
            return false;
        }
        return other.getDocumentReaderConfig() == null || other.getDocumentReaderConfig().equals(this.getDocumentReaderConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointArn() == null ? 0 : this.getEndpointArn().hashCode());
        hashCode = 31 * hashCode + (this.getBytes() == null ? 0 : this.getBytes().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentReaderConfig() == null ? 0 : this.getDocumentReaderConfig().hashCode());
        return hashCode;
    }

    public DetectEntitiesRequest clone() {
        return (DetectEntitiesRequest)super.clone();
    }
}

