/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.PiiEntityType;
import com.amazonaws.services.comprehend.model.transform.PiiEntityMarshaller;
import java.io.Serializable;

public class PiiEntity
implements Serializable,
Cloneable,
StructuredPojo {
    private Float score;
    private String type;
    private Integer beginOffset;
    private Integer endOffset;

    public void setScore(Float score) {
        this.score = score;
    }

    public Float getScore() {
        return this.score;
    }

    public PiiEntity withScore(Float score) {
        this.setScore(score);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public PiiEntity withType(String type) {
        this.setType(type);
        return this;
    }

    public PiiEntity withType(PiiEntityType type) {
        this.type = type.toString();
        return this;
    }

    public void setBeginOffset(Integer beginOffset) {
        this.beginOffset = beginOffset;
    }

    public Integer getBeginOffset() {
        return this.beginOffset;
    }

    public PiiEntity withBeginOffset(Integer beginOffset) {
        this.setBeginOffset(beginOffset);
        return this;
    }

    public void setEndOffset(Integer endOffset) {
        this.endOffset = endOffset;
    }

    public Integer getEndOffset() {
        return this.endOffset;
    }

    public PiiEntity withEndOffset(Integer endOffset) {
        this.setEndOffset(endOffset);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScore() != null) {
            sb.append("Score: ").append(this.getScore()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getBeginOffset() != null) {
            sb.append("BeginOffset: ").append(this.getBeginOffset()).append(",");
        }
        if (this.getEndOffset() != null) {
            sb.append("EndOffset: ").append(this.getEndOffset());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PiiEntity)) {
            return false;
        }
        PiiEntity other = (PiiEntity)obj;
        if (other.getScore() == null ^ this.getScore() == null) {
            return false;
        }
        if (other.getScore() != null && !other.getScore().equals(this.getScore())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getBeginOffset() == null ^ this.getBeginOffset() == null) {
            return false;
        }
        if (other.getBeginOffset() != null && !other.getBeginOffset().equals(this.getBeginOffset())) {
            return false;
        }
        if (other.getEndOffset() == null ^ this.getEndOffset() == null) {
            return false;
        }
        return other.getEndOffset() == null || other.getEndOffset().equals(this.getEndOffset());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScore() == null ? 0 : this.getScore().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getBeginOffset() == null ? 0 : this.getBeginOffset().hashCode());
        hashCode = 31 * hashCode + (this.getEndOffset() == null ? 0 : this.getEndOffset().hashCode());
        return hashCode;
    }

    public PiiEntity clone() {
        try {
            return (PiiEntity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PiiEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

