/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDetectEntitiesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> textList;
    private String languageCode;

    public List<String> getTextList() {
        return this.textList;
    }

    public void setTextList(Collection<String> textList) {
        if (textList == null) {
            this.textList = null;
            return;
        }
        this.textList = new ArrayList<String>(textList);
    }

    public BatchDetectEntitiesRequest withTextList(String ... textList) {
        if (this.textList == null) {
            this.setTextList(new ArrayList<String>(textList.length));
        }
        for (String ele : textList) {
            this.textList.add(ele);
        }
        return this;
    }

    public BatchDetectEntitiesRequest withTextList(Collection<String> textList) {
        this.setTextList(textList);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public BatchDetectEntitiesRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTextList() != null) {
            sb.append("TextList: ").append(this.getTextList()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectEntitiesRequest)) {
            return false;
        }
        BatchDetectEntitiesRequest other = (BatchDetectEntitiesRequest)obj;
        if (other.getTextList() == null ^ this.getTextList() == null) {
            return false;
        }
        if (other.getTextList() != null && !other.getTextList().equals(this.getTextList())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        return other.getLanguageCode() == null || other.getLanguageCode().equals(this.getLanguageCode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTextList() == null ? 0 : this.getTextList().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        return hashCode;
    }

    public BatchDetectEntitiesRequest clone() {
        return (BatchDetectEntitiesRequest)super.clone();
    }
}

