/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateUserAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<AttributeType> userAttributes;
    private String accessToken;
    private Map<String, String> clientMetadata;

    public List<AttributeType> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        this.userAttributes = new ArrayList<AttributeType>(userAttributes);
    }

    public UpdateUserAttributesRequest withUserAttributes(AttributeType ... userAttributes) {
        if (this.userAttributes == null) {
            this.setUserAttributes(new ArrayList<AttributeType>(userAttributes.length));
        }
        for (AttributeType ele : userAttributes) {
            this.userAttributes.add(ele);
        }
        return this;
    }

    public UpdateUserAttributesRequest withUserAttributes(Collection<AttributeType> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public UpdateUserAttributesRequest withAccessToken(String accessToken) {
        this.setAccessToken(accessToken);
        return this;
    }

    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    public UpdateUserAttributesRequest withClientMetadata(Map<String, String> clientMetadata) {
        this.setClientMetadata(clientMetadata);
        return this;
    }

    public UpdateUserAttributesRequest addClientMetadataEntry(String key, String value) {
        if (null == this.clientMetadata) {
            this.clientMetadata = new HashMap<String, String>();
        }
        if (this.clientMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.clientMetadata.put(key, value);
        return this;
    }

    public UpdateUserAttributesRequest clearClientMetadataEntries() {
        this.clientMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: ").append(this.getUserAttributes()).append(",");
        }
        if (this.getAccessToken() != null) {
            sb.append("AccessToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getClientMetadata() != null) {
            sb.append("ClientMetadata: ").append(this.getClientMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserAttributesRequest)) {
            return false;
        }
        UpdateUserAttributesRequest other = (UpdateUserAttributesRequest)obj;
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getAccessToken() == null ^ this.getAccessToken() == null) {
            return false;
        }
        if (other.getAccessToken() != null && !other.getAccessToken().equals(this.getAccessToken())) {
            return false;
        }
        if (other.getClientMetadata() == null ^ this.getClientMetadata() == null) {
            return false;
        }
        return other.getClientMetadata() == null || other.getClientMetadata().equals(this.getClientMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAccessToken() == null ? 0 : this.getAccessToken().hashCode());
        hashCode = 31 * hashCode + (this.getClientMetadata() == null ? 0 : this.getClientMetadata().hashCode());
        return hashCode;
    }

    public UpdateUserAttributesRequest clone() {
        return (UpdateUserAttributesRequest)super.clone();
    }
}

