/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestar.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codestar.model.CodeDestination;

@SdkInternalApi
public class CodeDestinationMarshaller {
    private static final MarshallingInfo<StructuredPojo> CODECOMMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codeCommit").build();
    private static final MarshallingInfo<StructuredPojo> GITHUB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gitHub").build();
    private static final CodeDestinationMarshaller instance = new CodeDestinationMarshaller();

    public static CodeDestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeDestination codeDestination, ProtocolMarshaller protocolMarshaller) {
        if (codeDestination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)codeDestination.getCodeCommit(), CODECOMMIT_BINDING);
            protocolMarshaller.marshall((Object)codeDestination.getGitHub(), GITHUB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

