/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.ArtifactRevision;
import com.amazonaws.services.codepipeline.model.ExecutionTrigger;
import com.amazonaws.services.codepipeline.model.PipelineExecutionStatus;
import com.amazonaws.services.codepipeline.model.ResolvedPipelineVariable;
import com.amazonaws.services.codepipeline.model.transform.PipelineExecutionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PipelineExecution
implements Serializable,
Cloneable,
StructuredPojo {
    private String pipelineName;
    private Integer pipelineVersion;
    private String pipelineExecutionId;
    private String status;
    private String statusSummary;
    private List<ArtifactRevision> artifactRevisions;
    private ExecutionTrigger trigger;
    private List<ResolvedPipelineVariable> variables;

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public PipelineExecution withPipelineName(String pipelineName) {
        this.setPipelineName(pipelineName);
        return this;
    }

    public void setPipelineVersion(Integer pipelineVersion) {
        this.pipelineVersion = pipelineVersion;
    }

    public Integer getPipelineVersion() {
        return this.pipelineVersion;
    }

    public PipelineExecution withPipelineVersion(Integer pipelineVersion) {
        this.setPipelineVersion(pipelineVersion);
        return this;
    }

    public void setPipelineExecutionId(String pipelineExecutionId) {
        this.pipelineExecutionId = pipelineExecutionId;
    }

    public String getPipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public PipelineExecution withPipelineExecutionId(String pipelineExecutionId) {
        this.setPipelineExecutionId(pipelineExecutionId);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public PipelineExecution withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(PipelineExecutionStatus status) {
        this.withStatus(status);
    }

    public PipelineExecution withStatus(PipelineExecutionStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusSummary(String statusSummary) {
        this.statusSummary = statusSummary;
    }

    public String getStatusSummary() {
        return this.statusSummary;
    }

    public PipelineExecution withStatusSummary(String statusSummary) {
        this.setStatusSummary(statusSummary);
        return this;
    }

    public List<ArtifactRevision> getArtifactRevisions() {
        return this.artifactRevisions;
    }

    public void setArtifactRevisions(Collection<ArtifactRevision> artifactRevisions) {
        if (artifactRevisions == null) {
            this.artifactRevisions = null;
            return;
        }
        this.artifactRevisions = new ArrayList<ArtifactRevision>(artifactRevisions);
    }

    public PipelineExecution withArtifactRevisions(ArtifactRevision ... artifactRevisions) {
        if (this.artifactRevisions == null) {
            this.setArtifactRevisions(new ArrayList<ArtifactRevision>(artifactRevisions.length));
        }
        for (ArtifactRevision ele : artifactRevisions) {
            this.artifactRevisions.add(ele);
        }
        return this;
    }

    public PipelineExecution withArtifactRevisions(Collection<ArtifactRevision> artifactRevisions) {
        this.setArtifactRevisions(artifactRevisions);
        return this;
    }

    public void setTrigger(ExecutionTrigger trigger) {
        this.trigger = trigger;
    }

    public ExecutionTrigger getTrigger() {
        return this.trigger;
    }

    public PipelineExecution withTrigger(ExecutionTrigger trigger) {
        this.setTrigger(trigger);
        return this;
    }

    public List<ResolvedPipelineVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<ResolvedPipelineVariable> variables) {
        if (variables == null) {
            this.variables = null;
            return;
        }
        this.variables = new ArrayList<ResolvedPipelineVariable>(variables);
    }

    public PipelineExecution withVariables(ResolvedPipelineVariable ... variables) {
        if (this.variables == null) {
            this.setVariables(new ArrayList<ResolvedPipelineVariable>(variables.length));
        }
        for (ResolvedPipelineVariable ele : variables) {
            this.variables.add(ele);
        }
        return this;
    }

    public PipelineExecution withVariables(Collection<ResolvedPipelineVariable> variables) {
        this.setVariables(variables);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineName() != null) {
            sb.append("PipelineName: ").append(this.getPipelineName()).append(",");
        }
        if (this.getPipelineVersion() != null) {
            sb.append("PipelineVersion: ").append(this.getPipelineVersion()).append(",");
        }
        if (this.getPipelineExecutionId() != null) {
            sb.append("PipelineExecutionId: ").append(this.getPipelineExecutionId()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusSummary() != null) {
            sb.append("StatusSummary: ").append(this.getStatusSummary()).append(",");
        }
        if (this.getArtifactRevisions() != null) {
            sb.append("ArtifactRevisions: ").append(this.getArtifactRevisions()).append(",");
        }
        if (this.getTrigger() != null) {
            sb.append("Trigger: ").append(this.getTrigger()).append(",");
        }
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecution)) {
            return false;
        }
        PipelineExecution other = (PipelineExecution)obj;
        if (other.getPipelineName() == null ^ this.getPipelineName() == null) {
            return false;
        }
        if (other.getPipelineName() != null && !other.getPipelineName().equals(this.getPipelineName())) {
            return false;
        }
        if (other.getPipelineVersion() == null ^ this.getPipelineVersion() == null) {
            return false;
        }
        if (other.getPipelineVersion() != null && !other.getPipelineVersion().equals(this.getPipelineVersion())) {
            return false;
        }
        if (other.getPipelineExecutionId() == null ^ this.getPipelineExecutionId() == null) {
            return false;
        }
        if (other.getPipelineExecutionId() != null && !other.getPipelineExecutionId().equals(this.getPipelineExecutionId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusSummary() == null ^ this.getStatusSummary() == null) {
            return false;
        }
        if (other.getStatusSummary() != null && !other.getStatusSummary().equals(this.getStatusSummary())) {
            return false;
        }
        if (other.getArtifactRevisions() == null ^ this.getArtifactRevisions() == null) {
            return false;
        }
        if (other.getArtifactRevisions() != null && !other.getArtifactRevisions().equals(this.getArtifactRevisions())) {
            return false;
        }
        if (other.getTrigger() == null ^ this.getTrigger() == null) {
            return false;
        }
        if (other.getTrigger() != null && !other.getTrigger().equals(this.getTrigger())) {
            return false;
        }
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        return other.getVariables() == null || other.getVariables().equals(this.getVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineName() == null ? 0 : this.getPipelineName().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineVersion() == null ? 0 : this.getPipelineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineExecutionId() == null ? 0 : this.getPipelineExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusSummary() == null ? 0 : this.getStatusSummary().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactRevisions() == null ? 0 : this.getArtifactRevisions().hashCode());
        hashCode = 31 * hashCode + (this.getTrigger() == null ? 0 : this.getTrigger().hashCode());
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        return hashCode;
    }

    public PipelineExecution clone() {
        try {
            return (PipelineExecution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

