/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.codepipeline.AWSCodePipeline;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobResult;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobResult;
import com.amazonaws.services.codepipeline.model.ActionNotFoundException;
import com.amazonaws.services.codepipeline.model.ActionTypeNotFoundException;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeResult;
import com.amazonaws.services.codepipeline.model.CreatePipelineRequest;
import com.amazonaws.services.codepipeline.model.CreatePipelineResult;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.DeletePipelineRequest;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.GetJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetJobDetailsResult;
import com.amazonaws.services.codepipeline.model.GetPipelineRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineResult;
import com.amazonaws.services.codepipeline.model.GetPipelineStateRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineStateResult;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsResult;
import com.amazonaws.services.codepipeline.model.InvalidActionDeclarationException;
import com.amazonaws.services.codepipeline.model.InvalidBlockerDeclarationException;
import com.amazonaws.services.codepipeline.model.InvalidClientTokenException;
import com.amazonaws.services.codepipeline.model.InvalidJobException;
import com.amazonaws.services.codepipeline.model.InvalidJobStateException;
import com.amazonaws.services.codepipeline.model.InvalidNextTokenException;
import com.amazonaws.services.codepipeline.model.InvalidNonceException;
import com.amazonaws.services.codepipeline.model.InvalidStageDeclarationException;
import com.amazonaws.services.codepipeline.model.InvalidStructureException;
import com.amazonaws.services.codepipeline.model.JobNotFoundException;
import com.amazonaws.services.codepipeline.model.LimitExceededException;
import com.amazonaws.services.codepipeline.model.ListActionTypesRequest;
import com.amazonaws.services.codepipeline.model.ListActionTypesResult;
import com.amazonaws.services.codepipeline.model.ListPipelinesRequest;
import com.amazonaws.services.codepipeline.model.ListPipelinesResult;
import com.amazonaws.services.codepipeline.model.PipelineNameInUseException;
import com.amazonaws.services.codepipeline.model.PipelineNotFoundException;
import com.amazonaws.services.codepipeline.model.PipelineVersionNotFoundException;
import com.amazonaws.services.codepipeline.model.PollForJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForJobsResult;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsResult;
import com.amazonaws.services.codepipeline.model.PutActionRevisionRequest;
import com.amazonaws.services.codepipeline.model.PutActionRevisionResult;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.StageNotFoundException;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.UpdatePipelineRequest;
import com.amazonaws.services.codepipeline.model.UpdatePipelineResult;
import com.amazonaws.services.codepipeline.model.ValidationException;
import com.amazonaws.services.codepipeline.model.transform.AcknowledgeJobRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.AcknowledgeJobResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.AcknowledgeThirdPartyJobRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.AcknowledgeThirdPartyJobResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.CreateCustomActionTypeRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.CreateCustomActionTypeResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.CreatePipelineRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.DeleteCustomActionTypeRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.DeletePipelineRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.DisableStageTransitionRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.EnableStageTransitionRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetJobDetailsRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetJobDetailsResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineStateRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineStateResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetThirdPartyJobDetailsRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetThirdPartyJobDetailsResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListActionTypesRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListActionTypesResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListPipelinesRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PollForJobsRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PollForJobsResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PollForThirdPartyJobsRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PollForThirdPartyJobsResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutActionRevisionRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutActionRevisionResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutJobFailureResultRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutJobSuccessResultRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutThirdPartyJobFailureResultRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutThirdPartyJobSuccessResultRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.StartPipelineExecutionRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.StartPipelineExecutionResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.UpdatePipelineRequestMarshaller;
import com.amazonaws.services.codepipeline.model.transform.UpdatePipelineResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCodePipelineClient
extends AmazonWebServiceClient
implements AWSCodePipeline {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCodePipeline.class);
    private static final String DEFAULT_SIGNING_NAME = "codepipeline";
    private static final String DEFAULT_ENDPOINT_PREFIX = "codepipeline";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSCodePipelineClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AWSCodePipelineClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSCodePipelineClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSCodePipelineClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSCodePipelineClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSCodePipelineClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSCodePipelineClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ActionNotFoundException.class, "ActionNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(JobNotFoundException.class, "JobNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LimitExceededException.class, "LimitExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(PipelineNameInUseException.class, "PipelineNameInUseException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidBlockerDeclarationException.class, "InvalidBlockerDeclarationException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidStructureException.class, "InvalidStructureException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(PipelineVersionNotFoundException.class, "PipelineVersionNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidStageDeclarationException.class, "InvalidStageDeclarationException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ValidationException.class, "ValidationException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ActionTypeNotFoundException.class, "ActionTypeNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(StageNotFoundException.class, "StageNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidClientTokenException.class, "InvalidClientTokenException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidNonceException.class, "InvalidNonceException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidNextTokenException.class, "InvalidNextTokenException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(PipelineNotFoundException.class, "PipelineNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidJobException.class, "InvalidJobException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidJobStateException.class, "InvalidJobStateException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidActionDeclarationException.class, "InvalidActionDeclarationException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern("codepipeline");
        this.setEndpointPrefix("codepipeline");
        this.setEndpoint("https://codepipeline.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codepipeline/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codepipeline/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcknowledgeJobResult acknowledgeJob(AcknowledgeJobRequest acknowledgeJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acknowledgeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcknowledgeJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcknowledgeJobRequestMarshaller().marshall((AcknowledgeJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)acknowledgeJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new AcknowledgeJobResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AcknowledgeJobResult acknowledgeJobResult = (AcknowledgeJobResult)response.getAwsResponse();
            return acknowledgeJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcknowledgeThirdPartyJobResult acknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acknowledgeThirdPartyJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcknowledgeThirdPartyJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcknowledgeThirdPartyJobRequestMarshaller().marshall((AcknowledgeThirdPartyJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)acknowledgeThirdPartyJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new AcknowledgeThirdPartyJobResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AcknowledgeThirdPartyJobResult acknowledgeThirdPartyJobResult = (AcknowledgeThirdPartyJobResult)response.getAwsResponse();
            return acknowledgeThirdPartyJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomActionTypeResult createCustomActionType(CreateCustomActionTypeRequest createCustomActionTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCustomActionTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCustomActionTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCustomActionTypeRequestMarshaller().marshall((CreateCustomActionTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createCustomActionTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateCustomActionTypeResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateCustomActionTypeResult createCustomActionTypeResult = (CreateCustomActionTypeResult)response.getAwsResponse();
            return createCustomActionTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest createPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePipelineRequestMarshaller().marshall((CreatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreatePipelineResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreatePipelineResult createPipelineResult = (CreatePipelineResult)response.getAwsResponse();
            return createPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCustomActionType(DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCustomActionTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCustomActionTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCustomActionTypeRequestMarshaller().marshall((DeleteCustomActionTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteCustomActionTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePipelineRequestMarshaller().marshall((DeletePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableStageTransition(DisableStageTransitionRequest disableStageTransitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableStageTransitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableStageTransitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableStageTransitionRequestMarshaller().marshall((DisableStageTransitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableStageTransitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableStageTransition(EnableStageTransitionRequest enableStageTransitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableStageTransitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableStageTransitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableStageTransitionRequestMarshaller().marshall((EnableStageTransitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableStageTransitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobDetailsResult getJobDetails(GetJobDetailsRequest getJobDetailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobDetailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobDetailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobDetailsRequestMarshaller().marshall((GetJobDetailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobDetailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetJobDetailsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetJobDetailsResult getJobDetailsResult = (GetJobDetailsResult)response.getAwsResponse();
            return getJobDetailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineResult getPipeline(GetPipelineRequest getPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineRequestMarshaller().marshall((GetPipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetPipelineResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetPipelineResult getPipelineResult = (GetPipelineResult)response.getAwsResponse();
            return getPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineStateResult getPipelineState(GetPipelineStateRequest getPipelineStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineStateRequestMarshaller().marshall((GetPipelineStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPipelineStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetPipelineStateResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetPipelineStateResult getPipelineStateResult = (GetPipelineStateResult)response.getAwsResponse();
            return getPipelineStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetThirdPartyJobDetailsResult getThirdPartyJobDetails(GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getThirdPartyJobDetailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetThirdPartyJobDetailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetThirdPartyJobDetailsRequestMarshaller().marshall((GetThirdPartyJobDetailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getThirdPartyJobDetailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetThirdPartyJobDetailsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetThirdPartyJobDetailsResult getThirdPartyJobDetailsResult = (GetThirdPartyJobDetailsResult)response.getAwsResponse();
            return getThirdPartyJobDetailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListActionTypesResult listActionTypes(ListActionTypesRequest listActionTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listActionTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListActionTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListActionTypesRequestMarshaller().marshall((ListActionTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listActionTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListActionTypesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListActionTypesResult listActionTypesResult = (ListActionTypesResult)response.getAwsResponse();
            return listActionTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest listPipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelinesRequestMarshaller().marshall((ListPipelinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPipelinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListPipelinesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListPipelinesResult listPipelinesResult = (ListPipelinesResult)response.getAwsResponse();
            return listPipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollForJobsResult pollForJobs(PollForJobsRequest pollForJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForJobsRequestMarshaller().marshall((PollForJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)pollForJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new PollForJobsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PollForJobsResult pollForJobsResult = (PollForJobsResult)response.getAwsResponse();
            return pollForJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollForThirdPartyJobsResult pollForThirdPartyJobs(PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForThirdPartyJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForThirdPartyJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForThirdPartyJobsRequestMarshaller().marshall((PollForThirdPartyJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)pollForThirdPartyJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new PollForThirdPartyJobsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PollForThirdPartyJobsResult pollForThirdPartyJobsResult = (PollForThirdPartyJobsResult)response.getAwsResponse();
            return pollForThirdPartyJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutActionRevisionResult putActionRevision(PutActionRevisionRequest putActionRevisionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putActionRevisionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutActionRevisionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutActionRevisionRequestMarshaller().marshall((PutActionRevisionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putActionRevisionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new PutActionRevisionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutActionRevisionResult putActionRevisionResult = (PutActionRevisionResult)response.getAwsResponse();
            return putActionRevisionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putJobFailureResult(PutJobFailureResultRequest putJobFailureResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putJobFailureResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutJobFailureResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutJobFailureResultRequestMarshaller().marshall((PutJobFailureResultRequest)super.beforeMarshalling((AmazonWebServiceRequest)putJobFailureResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putJobSuccessResult(PutJobSuccessResultRequest putJobSuccessResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putJobSuccessResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutJobSuccessResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutJobSuccessResultRequestMarshaller().marshall((PutJobSuccessResultRequest)super.beforeMarshalling((AmazonWebServiceRequest)putJobSuccessResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putThirdPartyJobFailureResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutThirdPartyJobFailureResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutThirdPartyJobFailureResultRequestMarshaller().marshall((PutThirdPartyJobFailureResultRequest)super.beforeMarshalling((AmazonWebServiceRequest)putThirdPartyJobFailureResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putThirdPartyJobSuccessResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutThirdPartyJobSuccessResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutThirdPartyJobSuccessResultRequestMarshaller().marshall((PutThirdPartyJobSuccessResultRequest)super.beforeMarshalling((AmazonWebServiceRequest)putThirdPartyJobSuccessResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPipelineExecutionResult startPipelineExecution(StartPipelineExecutionRequest startPipelineExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startPipelineExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartPipelineExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartPipelineExecutionRequestMarshaller().marshall((StartPipelineExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startPipelineExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new StartPipelineExecutionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            StartPipelineExecutionResult startPipelineExecutionResult = (StartPipelineExecutionResult)response.getAwsResponse();
            return startPipelineExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineRequestMarshaller().marshall((UpdatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdatePipelineResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdatePipelineResult updatePipelineResult = (UpdatePipelineResult)response.getAwsResponse();
            return updatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

