/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.services.codepipeline.model.AWSSessionCredentials;
import com.amazonaws.services.codepipeline.model.ActionConfiguration;
import com.amazonaws.services.codepipeline.model.ActionTypeId;
import com.amazonaws.services.codepipeline.model.Artifact;
import com.amazonaws.services.codepipeline.model.EncryptionKey;
import com.amazonaws.services.codepipeline.model.PipelineContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ThirdPartyJobData
implements Serializable,
Cloneable {
    private ActionTypeId actionTypeId;
    private ActionConfiguration actionConfiguration;
    private PipelineContext pipelineContext;
    private List<Artifact> inputArtifacts;
    private List<Artifact> outputArtifacts;
    private AWSSessionCredentials artifactCredentials;
    private String continuationToken;
    private EncryptionKey encryptionKey;

    public void setActionTypeId(ActionTypeId actionTypeId) {
        this.actionTypeId = actionTypeId;
    }

    public ActionTypeId getActionTypeId() {
        return this.actionTypeId;
    }

    public ThirdPartyJobData withActionTypeId(ActionTypeId actionTypeId) {
        this.setActionTypeId(actionTypeId);
        return this;
    }

    public void setActionConfiguration(ActionConfiguration actionConfiguration) {
        this.actionConfiguration = actionConfiguration;
    }

    public ActionConfiguration getActionConfiguration() {
        return this.actionConfiguration;
    }

    public ThirdPartyJobData withActionConfiguration(ActionConfiguration actionConfiguration) {
        this.setActionConfiguration(actionConfiguration);
        return this;
    }

    public void setPipelineContext(PipelineContext pipelineContext) {
        this.pipelineContext = pipelineContext;
    }

    public PipelineContext getPipelineContext() {
        return this.pipelineContext;
    }

    public ThirdPartyJobData withPipelineContext(PipelineContext pipelineContext) {
        this.setPipelineContext(pipelineContext);
        return this;
    }

    public List<Artifact> getInputArtifacts() {
        return this.inputArtifacts;
    }

    public void setInputArtifacts(Collection<Artifact> inputArtifacts) {
        if (inputArtifacts == null) {
            this.inputArtifacts = null;
            return;
        }
        this.inputArtifacts = new ArrayList<Artifact>(inputArtifacts);
    }

    public ThirdPartyJobData withInputArtifacts(Artifact ... inputArtifacts) {
        if (this.inputArtifacts == null) {
            this.setInputArtifacts(new ArrayList<Artifact>(inputArtifacts.length));
        }
        for (Artifact ele : inputArtifacts) {
            this.inputArtifacts.add(ele);
        }
        return this;
    }

    public ThirdPartyJobData withInputArtifacts(Collection<Artifact> inputArtifacts) {
        this.setInputArtifacts(inputArtifacts);
        return this;
    }

    public List<Artifact> getOutputArtifacts() {
        return this.outputArtifacts;
    }

    public void setOutputArtifacts(Collection<Artifact> outputArtifacts) {
        if (outputArtifacts == null) {
            this.outputArtifacts = null;
            return;
        }
        this.outputArtifacts = new ArrayList<Artifact>(outputArtifacts);
    }

    public ThirdPartyJobData withOutputArtifacts(Artifact ... outputArtifacts) {
        if (this.outputArtifacts == null) {
            this.setOutputArtifacts(new ArrayList<Artifact>(outputArtifacts.length));
        }
        for (Artifact ele : outputArtifacts) {
            this.outputArtifacts.add(ele);
        }
        return this;
    }

    public ThirdPartyJobData withOutputArtifacts(Collection<Artifact> outputArtifacts) {
        this.setOutputArtifacts(outputArtifacts);
        return this;
    }

    public void setArtifactCredentials(AWSSessionCredentials artifactCredentials) {
        this.artifactCredentials = artifactCredentials;
    }

    public AWSSessionCredentials getArtifactCredentials() {
        return this.artifactCredentials;
    }

    public ThirdPartyJobData withArtifactCredentials(AWSSessionCredentials artifactCredentials) {
        this.setArtifactCredentials(artifactCredentials);
        return this;
    }

    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public ThirdPartyJobData withContinuationToken(String continuationToken) {
        this.setContinuationToken(continuationToken);
        return this;
    }

    public void setEncryptionKey(EncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public EncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public ThirdPartyJobData withEncryptionKey(EncryptionKey encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionTypeId() != null) {
            sb.append("ActionTypeId: " + this.getActionTypeId() + ",");
        }
        if (this.getActionConfiguration() != null) {
            sb.append("ActionConfiguration: " + this.getActionConfiguration() + ",");
        }
        if (this.getPipelineContext() != null) {
            sb.append("PipelineContext: " + this.getPipelineContext() + ",");
        }
        if (this.getInputArtifacts() != null) {
            sb.append("InputArtifacts: " + this.getInputArtifacts() + ",");
        }
        if (this.getOutputArtifacts() != null) {
            sb.append("OutputArtifacts: " + this.getOutputArtifacts() + ",");
        }
        if (this.getArtifactCredentials() != null) {
            sb.append("ArtifactCredentials: " + this.getArtifactCredentials() + ",");
        }
        if (this.getContinuationToken() != null) {
            sb.append("ContinuationToken: " + this.getContinuationToken() + ",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: " + this.getEncryptionKey());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThirdPartyJobData)) {
            return false;
        }
        ThirdPartyJobData other = (ThirdPartyJobData)obj;
        if (other.getActionTypeId() == null ^ this.getActionTypeId() == null) {
            return false;
        }
        if (other.getActionTypeId() != null && !other.getActionTypeId().equals(this.getActionTypeId())) {
            return false;
        }
        if (other.getActionConfiguration() == null ^ this.getActionConfiguration() == null) {
            return false;
        }
        if (other.getActionConfiguration() != null && !other.getActionConfiguration().equals(this.getActionConfiguration())) {
            return false;
        }
        if (other.getPipelineContext() == null ^ this.getPipelineContext() == null) {
            return false;
        }
        if (other.getPipelineContext() != null && !other.getPipelineContext().equals(this.getPipelineContext())) {
            return false;
        }
        if (other.getInputArtifacts() == null ^ this.getInputArtifacts() == null) {
            return false;
        }
        if (other.getInputArtifacts() != null && !other.getInputArtifacts().equals(this.getInputArtifacts())) {
            return false;
        }
        if (other.getOutputArtifacts() == null ^ this.getOutputArtifacts() == null) {
            return false;
        }
        if (other.getOutputArtifacts() != null && !other.getOutputArtifacts().equals(this.getOutputArtifacts())) {
            return false;
        }
        if (other.getArtifactCredentials() == null ^ this.getArtifactCredentials() == null) {
            return false;
        }
        if (other.getArtifactCredentials() != null && !other.getArtifactCredentials().equals(this.getArtifactCredentials())) {
            return false;
        }
        if (other.getContinuationToken() == null ^ this.getContinuationToken() == null) {
            return false;
        }
        if (other.getContinuationToken() != null && !other.getContinuationToken().equals(this.getContinuationToken())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        return other.getEncryptionKey() == null || other.getEncryptionKey().equals(this.getEncryptionKey());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionTypeId() == null ? 0 : this.getActionTypeId().hashCode());
        hashCode = 31 * hashCode + (this.getActionConfiguration() == null ? 0 : this.getActionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineContext() == null ? 0 : this.getPipelineContext().hashCode());
        hashCode = 31 * hashCode + (this.getInputArtifacts() == null ? 0 : this.getInputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getOutputArtifacts() == null ? 0 : this.getOutputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactCredentials() == null ? 0 : this.getArtifactCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getContinuationToken() == null ? 0 : this.getContinuationToken().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        return hashCode;
    }

    public ThirdPartyJobData clone() {
        try {
            return (ThirdPartyJobData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

