/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurusecurity.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.codegurusecurity.model.ScanSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListScansResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ScanSummary> summaries;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListScansResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ScanSummary> getSummaries() {
        return this.summaries;
    }

    public void setSummaries(Collection<ScanSummary> summaries) {
        if (summaries == null) {
            this.summaries = null;
            return;
        }
        this.summaries = new ArrayList<ScanSummary>(summaries);
    }

    public ListScansResult withSummaries(ScanSummary ... summaries) {
        if (this.summaries == null) {
            this.setSummaries(new ArrayList<ScanSummary>(summaries.length));
        }
        for (ScanSummary ele : summaries) {
            this.summaries.add(ele);
        }
        return this;
    }

    public ListScansResult withSummaries(Collection<ScanSummary> summaries) {
        this.setSummaries(summaries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSummaries() != null) {
            sb.append("Summaries: ").append(this.getSummaries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScansResult)) {
            return false;
        }
        ListScansResult other = (ListScansResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSummaries() == null ^ this.getSummaries() == null) {
            return false;
        }
        return other.getSummaries() == null || other.getSummaries().equals(this.getSummaries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSummaries() == null ? 0 : this.getSummaries().hashCode());
        return hashCode;
    }

    public ListScansResult clone() {
        try {
            return (ListScansResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

