/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeguruprofiler.model.AnomalyInstance;
import java.util.Date;

@SdkInternalApi
public class AnomalyInstanceMarshaller {
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<StructuredPojo> USERFEEDBACK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userFeedback").build();
    private static final AnomalyInstanceMarshaller instance = new AnomalyInstanceMarshaller();

    public static AnomalyInstanceMarshaller getInstance() {
        return instance;
    }

    public void marshall(AnomalyInstance anomalyInstance, ProtocolMarshaller protocolMarshaller) {
        if (anomalyInstance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)anomalyInstance.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)anomalyInstance.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)anomalyInstance.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)anomalyInstance.getUserFeedback(), USERFEEDBACK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

