/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codedeploy.model.AlarmConfiguration;
import com.amazonaws.services.codedeploy.model.AutoRollbackConfiguration;
import com.amazonaws.services.codedeploy.model.AutoScalingGroup;
import com.amazonaws.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import com.amazonaws.services.codedeploy.model.ComputePlatform;
import com.amazonaws.services.codedeploy.model.DeploymentStyle;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.EC2TagSet;
import com.amazonaws.services.codedeploy.model.ECSService;
import com.amazonaws.services.codedeploy.model.LastDeploymentInfo;
import com.amazonaws.services.codedeploy.model.LoadBalancerInfo;
import com.amazonaws.services.codedeploy.model.OnPremisesTagSet;
import com.amazonaws.services.codedeploy.model.OutdatedInstancesStrategy;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.TriggerConfig;
import com.amazonaws.services.codedeploy.model.transform.DeploymentGroupInfoMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DeploymentGroupInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationName;
    private String deploymentGroupId;
    private String deploymentGroupName;
    private String deploymentConfigName;
    private SdkInternalList<EC2TagFilter> ec2TagFilters;
    private SdkInternalList<TagFilter> onPremisesInstanceTagFilters;
    private SdkInternalList<AutoScalingGroup> autoScalingGroups;
    private String serviceRoleArn;
    private RevisionLocation targetRevision;
    private SdkInternalList<TriggerConfig> triggerConfigurations;
    private AlarmConfiguration alarmConfiguration;
    private AutoRollbackConfiguration autoRollbackConfiguration;
    private DeploymentStyle deploymentStyle;
    private String outdatedInstancesStrategy;
    private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private LoadBalancerInfo loadBalancerInfo;
    private LastDeploymentInfo lastSuccessfulDeployment;
    private LastDeploymentInfo lastAttemptedDeployment;
    private EC2TagSet ec2TagSet;
    private OnPremisesTagSet onPremisesTagSet;
    private String computePlatform;
    private SdkInternalList<ECSService> ecsServices;
    private Boolean terminationHookEnabled;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public DeploymentGroupInfo withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setDeploymentGroupId(String deploymentGroupId) {
        this.deploymentGroupId = deploymentGroupId;
    }

    public String getDeploymentGroupId() {
        return this.deploymentGroupId;
    }

    public DeploymentGroupInfo withDeploymentGroupId(String deploymentGroupId) {
        this.setDeploymentGroupId(deploymentGroupId);
        return this;
    }

    public void setDeploymentGroupName(String deploymentGroupName) {
        this.deploymentGroupName = deploymentGroupName;
    }

    public String getDeploymentGroupName() {
        return this.deploymentGroupName;
    }

    public DeploymentGroupInfo withDeploymentGroupName(String deploymentGroupName) {
        this.setDeploymentGroupName(deploymentGroupName);
        return this;
    }

    public void setDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
    }

    public String getDeploymentConfigName() {
        return this.deploymentConfigName;
    }

    public DeploymentGroupInfo withDeploymentConfigName(String deploymentConfigName) {
        this.setDeploymentConfigName(deploymentConfigName);
        return this;
    }

    public List<EC2TagFilter> getEc2TagFilters() {
        if (this.ec2TagFilters == null) {
            this.ec2TagFilters = new SdkInternalList();
        }
        return this.ec2TagFilters;
    }

    public void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
            return;
        }
        this.ec2TagFilters = new SdkInternalList(ec2TagFilters);
    }

    public DeploymentGroupInfo withEc2TagFilters(EC2TagFilter ... ec2TagFilters) {
        if (this.ec2TagFilters == null) {
            this.setEc2TagFilters((Collection<EC2TagFilter>)new SdkInternalList(ec2TagFilters.length));
        }
        for (EC2TagFilter ele : ec2TagFilters) {
            this.ec2TagFilters.add((Object)ele);
        }
        return this;
    }

    public DeploymentGroupInfo withEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        this.setEc2TagFilters(ec2TagFilters);
        return this;
    }

    public List<TagFilter> getOnPremisesInstanceTagFilters() {
        if (this.onPremisesInstanceTagFilters == null) {
            this.onPremisesInstanceTagFilters = new SdkInternalList();
        }
        return this.onPremisesInstanceTagFilters;
    }

    public void setOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
        if (onPremisesInstanceTagFilters == null) {
            this.onPremisesInstanceTagFilters = null;
            return;
        }
        this.onPremisesInstanceTagFilters = new SdkInternalList(onPremisesInstanceTagFilters);
    }

    public DeploymentGroupInfo withOnPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
        if (this.onPremisesInstanceTagFilters == null) {
            this.setOnPremisesInstanceTagFilters((Collection<TagFilter>)new SdkInternalList(onPremisesInstanceTagFilters.length));
        }
        for (TagFilter ele : onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters.add((Object)ele);
        }
        return this;
    }

    public DeploymentGroupInfo withOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
        this.setOnPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
        return this;
    }

    public List<AutoScalingGroup> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new SdkInternalList();
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        this.autoScalingGroups = new SdkInternalList(autoScalingGroups);
    }

    public DeploymentGroupInfo withAutoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
        if (this.autoScalingGroups == null) {
            this.setAutoScalingGroups((Collection<AutoScalingGroup>)new SdkInternalList(autoScalingGroups.length));
        }
        for (AutoScalingGroup ele : autoScalingGroups) {
            this.autoScalingGroups.add((Object)ele);
        }
        return this;
    }

    public DeploymentGroupInfo withAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        this.setAutoScalingGroups(autoScalingGroups);
        return this;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public DeploymentGroupInfo withServiceRoleArn(String serviceRoleArn) {
        this.setServiceRoleArn(serviceRoleArn);
        return this;
    }

    public void setTargetRevision(RevisionLocation targetRevision) {
        this.targetRevision = targetRevision;
    }

    public RevisionLocation getTargetRevision() {
        return this.targetRevision;
    }

    public DeploymentGroupInfo withTargetRevision(RevisionLocation targetRevision) {
        this.setTargetRevision(targetRevision);
        return this;
    }

    public List<TriggerConfig> getTriggerConfigurations() {
        if (this.triggerConfigurations == null) {
            this.triggerConfigurations = new SdkInternalList();
        }
        return this.triggerConfigurations;
    }

    public void setTriggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
        if (triggerConfigurations == null) {
            this.triggerConfigurations = null;
            return;
        }
        this.triggerConfigurations = new SdkInternalList(triggerConfigurations);
    }

    public DeploymentGroupInfo withTriggerConfigurations(TriggerConfig ... triggerConfigurations) {
        if (this.triggerConfigurations == null) {
            this.setTriggerConfigurations((Collection<TriggerConfig>)new SdkInternalList(triggerConfigurations.length));
        }
        for (TriggerConfig ele : triggerConfigurations) {
            this.triggerConfigurations.add((Object)ele);
        }
        return this;
    }

    public DeploymentGroupInfo withTriggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
        this.setTriggerConfigurations(triggerConfigurations);
        return this;
    }

    public void setAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
        this.alarmConfiguration = alarmConfiguration;
    }

    public AlarmConfiguration getAlarmConfiguration() {
        return this.alarmConfiguration;
    }

    public DeploymentGroupInfo withAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
        this.setAlarmConfiguration(alarmConfiguration);
        return this;
    }

    public void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
        this.autoRollbackConfiguration = autoRollbackConfiguration;
    }

    public AutoRollbackConfiguration getAutoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public DeploymentGroupInfo withAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
        this.setAutoRollbackConfiguration(autoRollbackConfiguration);
        return this;
    }

    public void setDeploymentStyle(DeploymentStyle deploymentStyle) {
        this.deploymentStyle = deploymentStyle;
    }

    public DeploymentStyle getDeploymentStyle() {
        return this.deploymentStyle;
    }

    public DeploymentGroupInfo withDeploymentStyle(DeploymentStyle deploymentStyle) {
        this.setDeploymentStyle(deploymentStyle);
        return this;
    }

    public void setOutdatedInstancesStrategy(String outdatedInstancesStrategy) {
        this.outdatedInstancesStrategy = outdatedInstancesStrategy;
    }

    public String getOutdatedInstancesStrategy() {
        return this.outdatedInstancesStrategy;
    }

    public DeploymentGroupInfo withOutdatedInstancesStrategy(String outdatedInstancesStrategy) {
        this.setOutdatedInstancesStrategy(outdatedInstancesStrategy);
        return this;
    }

    public DeploymentGroupInfo withOutdatedInstancesStrategy(OutdatedInstancesStrategy outdatedInstancesStrategy) {
        this.outdatedInstancesStrategy = outdatedInstancesStrategy.toString();
        return this;
    }

    public void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
        this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
    }

    public BlueGreenDeploymentConfiguration getBlueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public DeploymentGroupInfo withBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
        this.setBlueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration);
        return this;
    }

    public void setLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
        this.loadBalancerInfo = loadBalancerInfo;
    }

    public LoadBalancerInfo getLoadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public DeploymentGroupInfo withLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
        this.setLoadBalancerInfo(loadBalancerInfo);
        return this;
    }

    public void setLastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment) {
        this.lastSuccessfulDeployment = lastSuccessfulDeployment;
    }

    public LastDeploymentInfo getLastSuccessfulDeployment() {
        return this.lastSuccessfulDeployment;
    }

    public DeploymentGroupInfo withLastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment) {
        this.setLastSuccessfulDeployment(lastSuccessfulDeployment);
        return this;
    }

    public void setLastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment) {
        this.lastAttemptedDeployment = lastAttemptedDeployment;
    }

    public LastDeploymentInfo getLastAttemptedDeployment() {
        return this.lastAttemptedDeployment;
    }

    public DeploymentGroupInfo withLastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment) {
        this.setLastAttemptedDeployment(lastAttemptedDeployment);
        return this;
    }

    public void setEc2TagSet(EC2TagSet ec2TagSet) {
        this.ec2TagSet = ec2TagSet;
    }

    public EC2TagSet getEc2TagSet() {
        return this.ec2TagSet;
    }

    public DeploymentGroupInfo withEc2TagSet(EC2TagSet ec2TagSet) {
        this.setEc2TagSet(ec2TagSet);
        return this;
    }

    public void setOnPremisesTagSet(OnPremisesTagSet onPremisesTagSet) {
        this.onPremisesTagSet = onPremisesTagSet;
    }

    public OnPremisesTagSet getOnPremisesTagSet() {
        return this.onPremisesTagSet;
    }

    public DeploymentGroupInfo withOnPremisesTagSet(OnPremisesTagSet onPremisesTagSet) {
        this.setOnPremisesTagSet(onPremisesTagSet);
        return this;
    }

    public void setComputePlatform(String computePlatform) {
        this.computePlatform = computePlatform;
    }

    public String getComputePlatform() {
        return this.computePlatform;
    }

    public DeploymentGroupInfo withComputePlatform(String computePlatform) {
        this.setComputePlatform(computePlatform);
        return this;
    }

    public DeploymentGroupInfo withComputePlatform(ComputePlatform computePlatform) {
        this.computePlatform = computePlatform.toString();
        return this;
    }

    public List<ECSService> getEcsServices() {
        if (this.ecsServices == null) {
            this.ecsServices = new SdkInternalList();
        }
        return this.ecsServices;
    }

    public void setEcsServices(Collection<ECSService> ecsServices) {
        if (ecsServices == null) {
            this.ecsServices = null;
            return;
        }
        this.ecsServices = new SdkInternalList(ecsServices);
    }

    public DeploymentGroupInfo withEcsServices(ECSService ... ecsServices) {
        if (this.ecsServices == null) {
            this.setEcsServices((Collection<ECSService>)new SdkInternalList(ecsServices.length));
        }
        for (ECSService ele : ecsServices) {
            this.ecsServices.add((Object)ele);
        }
        return this;
    }

    public DeploymentGroupInfo withEcsServices(Collection<ECSService> ecsServices) {
        this.setEcsServices(ecsServices);
        return this;
    }

    public void setTerminationHookEnabled(Boolean terminationHookEnabled) {
        this.terminationHookEnabled = terminationHookEnabled;
    }

    public Boolean getTerminationHookEnabled() {
        return this.terminationHookEnabled;
    }

    public DeploymentGroupInfo withTerminationHookEnabled(Boolean terminationHookEnabled) {
        this.setTerminationHookEnabled(terminationHookEnabled);
        return this;
    }

    public Boolean isTerminationHookEnabled() {
        return this.terminationHookEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getDeploymentGroupId() != null) {
            sb.append("DeploymentGroupId: ").append(this.getDeploymentGroupId()).append(",");
        }
        if (this.getDeploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(this.getDeploymentGroupName()).append(",");
        }
        if (this.getDeploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(this.getDeploymentConfigName()).append(",");
        }
        if (this.getEc2TagFilters() != null) {
            sb.append("Ec2TagFilters: ").append(this.getEc2TagFilters()).append(",");
        }
        if (this.getOnPremisesInstanceTagFilters() != null) {
            sb.append("OnPremisesInstanceTagFilters: ").append(this.getOnPremisesInstanceTagFilters()).append(",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.getAutoScalingGroups()).append(",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.getServiceRoleArn()).append(",");
        }
        if (this.getTargetRevision() != null) {
            sb.append("TargetRevision: ").append(this.getTargetRevision()).append(",");
        }
        if (this.getTriggerConfigurations() != null) {
            sb.append("TriggerConfigurations: ").append(this.getTriggerConfigurations()).append(",");
        }
        if (this.getAlarmConfiguration() != null) {
            sb.append("AlarmConfiguration: ").append(this.getAlarmConfiguration()).append(",");
        }
        if (this.getAutoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(this.getAutoRollbackConfiguration()).append(",");
        }
        if (this.getDeploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(this.getDeploymentStyle()).append(",");
        }
        if (this.getOutdatedInstancesStrategy() != null) {
            sb.append("OutdatedInstancesStrategy: ").append(this.getOutdatedInstancesStrategy()).append(",");
        }
        if (this.getBlueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(this.getBlueGreenDeploymentConfiguration()).append(",");
        }
        if (this.getLoadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(this.getLoadBalancerInfo()).append(",");
        }
        if (this.getLastSuccessfulDeployment() != null) {
            sb.append("LastSuccessfulDeployment: ").append(this.getLastSuccessfulDeployment()).append(",");
        }
        if (this.getLastAttemptedDeployment() != null) {
            sb.append("LastAttemptedDeployment: ").append(this.getLastAttemptedDeployment()).append(",");
        }
        if (this.getEc2TagSet() != null) {
            sb.append("Ec2TagSet: ").append(this.getEc2TagSet()).append(",");
        }
        if (this.getOnPremisesTagSet() != null) {
            sb.append("OnPremisesTagSet: ").append(this.getOnPremisesTagSet()).append(",");
        }
        if (this.getComputePlatform() != null) {
            sb.append("ComputePlatform: ").append(this.getComputePlatform()).append(",");
        }
        if (this.getEcsServices() != null) {
            sb.append("EcsServices: ").append(this.getEcsServices()).append(",");
        }
        if (this.getTerminationHookEnabled() != null) {
            sb.append("TerminationHookEnabled: ").append(this.getTerminationHookEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentGroupInfo)) {
            return false;
        }
        DeploymentGroupInfo other = (DeploymentGroupInfo)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getDeploymentGroupId() == null ^ this.getDeploymentGroupId() == null) {
            return false;
        }
        if (other.getDeploymentGroupId() != null && !other.getDeploymentGroupId().equals(this.getDeploymentGroupId())) {
            return false;
        }
        if (other.getDeploymentGroupName() == null ^ this.getDeploymentGroupName() == null) {
            return false;
        }
        if (other.getDeploymentGroupName() != null && !other.getDeploymentGroupName().equals(this.getDeploymentGroupName())) {
            return false;
        }
        if (other.getDeploymentConfigName() == null ^ this.getDeploymentConfigName() == null) {
            return false;
        }
        if (other.getDeploymentConfigName() != null && !other.getDeploymentConfigName().equals(this.getDeploymentConfigName())) {
            return false;
        }
        if (other.getEc2TagFilters() == null ^ this.getEc2TagFilters() == null) {
            return false;
        }
        if (other.getEc2TagFilters() != null && !other.getEc2TagFilters().equals(this.getEc2TagFilters())) {
            return false;
        }
        if (other.getOnPremisesInstanceTagFilters() == null ^ this.getOnPremisesInstanceTagFilters() == null) {
            return false;
        }
        if (other.getOnPremisesInstanceTagFilters() != null && !other.getOnPremisesInstanceTagFilters().equals(this.getOnPremisesInstanceTagFilters())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getTargetRevision() == null ^ this.getTargetRevision() == null) {
            return false;
        }
        if (other.getTargetRevision() != null && !other.getTargetRevision().equals(this.getTargetRevision())) {
            return false;
        }
        if (other.getTriggerConfigurations() == null ^ this.getTriggerConfigurations() == null) {
            return false;
        }
        if (other.getTriggerConfigurations() != null && !other.getTriggerConfigurations().equals(this.getTriggerConfigurations())) {
            return false;
        }
        if (other.getAlarmConfiguration() == null ^ this.getAlarmConfiguration() == null) {
            return false;
        }
        if (other.getAlarmConfiguration() != null && !other.getAlarmConfiguration().equals(this.getAlarmConfiguration())) {
            return false;
        }
        if (other.getAutoRollbackConfiguration() == null ^ this.getAutoRollbackConfiguration() == null) {
            return false;
        }
        if (other.getAutoRollbackConfiguration() != null && !other.getAutoRollbackConfiguration().equals(this.getAutoRollbackConfiguration())) {
            return false;
        }
        if (other.getDeploymentStyle() == null ^ this.getDeploymentStyle() == null) {
            return false;
        }
        if (other.getDeploymentStyle() != null && !other.getDeploymentStyle().equals(this.getDeploymentStyle())) {
            return false;
        }
        if (other.getOutdatedInstancesStrategy() == null ^ this.getOutdatedInstancesStrategy() == null) {
            return false;
        }
        if (other.getOutdatedInstancesStrategy() != null && !other.getOutdatedInstancesStrategy().equals(this.getOutdatedInstancesStrategy())) {
            return false;
        }
        if (other.getBlueGreenDeploymentConfiguration() == null ^ this.getBlueGreenDeploymentConfiguration() == null) {
            return false;
        }
        if (other.getBlueGreenDeploymentConfiguration() != null && !other.getBlueGreenDeploymentConfiguration().equals(this.getBlueGreenDeploymentConfiguration())) {
            return false;
        }
        if (other.getLoadBalancerInfo() == null ^ this.getLoadBalancerInfo() == null) {
            return false;
        }
        if (other.getLoadBalancerInfo() != null && !other.getLoadBalancerInfo().equals(this.getLoadBalancerInfo())) {
            return false;
        }
        if (other.getLastSuccessfulDeployment() == null ^ this.getLastSuccessfulDeployment() == null) {
            return false;
        }
        if (other.getLastSuccessfulDeployment() != null && !other.getLastSuccessfulDeployment().equals(this.getLastSuccessfulDeployment())) {
            return false;
        }
        if (other.getLastAttemptedDeployment() == null ^ this.getLastAttemptedDeployment() == null) {
            return false;
        }
        if (other.getLastAttemptedDeployment() != null && !other.getLastAttemptedDeployment().equals(this.getLastAttemptedDeployment())) {
            return false;
        }
        if (other.getEc2TagSet() == null ^ this.getEc2TagSet() == null) {
            return false;
        }
        if (other.getEc2TagSet() != null && !other.getEc2TagSet().equals(this.getEc2TagSet())) {
            return false;
        }
        if (other.getOnPremisesTagSet() == null ^ this.getOnPremisesTagSet() == null) {
            return false;
        }
        if (other.getOnPremisesTagSet() != null && !other.getOnPremisesTagSet().equals(this.getOnPremisesTagSet())) {
            return false;
        }
        if (other.getComputePlatform() == null ^ this.getComputePlatform() == null) {
            return false;
        }
        if (other.getComputePlatform() != null && !other.getComputePlatform().equals(this.getComputePlatform())) {
            return false;
        }
        if (other.getEcsServices() == null ^ this.getEcsServices() == null) {
            return false;
        }
        if (other.getEcsServices() != null && !other.getEcsServices().equals(this.getEcsServices())) {
            return false;
        }
        if (other.getTerminationHookEnabled() == null ^ this.getTerminationHookEnabled() == null) {
            return false;
        }
        return other.getTerminationHookEnabled() == null || other.getTerminationHookEnabled().equals(this.getTerminationHookEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroupId() == null ? 0 : this.getDeploymentGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroupName() == null ? 0 : this.getDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfigName() == null ? 0 : this.getDeploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getEc2TagFilters() == null ? 0 : this.getEc2TagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getOnPremisesInstanceTagFilters() == null ? 0 : this.getOnPremisesInstanceTagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetRevision() == null ? 0 : this.getTargetRevision().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerConfigurations() == null ? 0 : this.getTriggerConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getAlarmConfiguration() == null ? 0 : this.getAlarmConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAutoRollbackConfiguration() == null ? 0 : this.getAutoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentStyle() == null ? 0 : this.getDeploymentStyle().hashCode());
        hashCode = 31 * hashCode + (this.getOutdatedInstancesStrategy() == null ? 0 : this.getOutdatedInstancesStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getBlueGreenDeploymentConfiguration() == null ? 0 : this.getBlueGreenDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerInfo() == null ? 0 : this.getLoadBalancerInfo().hashCode());
        hashCode = 31 * hashCode + (this.getLastSuccessfulDeployment() == null ? 0 : this.getLastSuccessfulDeployment().hashCode());
        hashCode = 31 * hashCode + (this.getLastAttemptedDeployment() == null ? 0 : this.getLastAttemptedDeployment().hashCode());
        hashCode = 31 * hashCode + (this.getEc2TagSet() == null ? 0 : this.getEc2TagSet().hashCode());
        hashCode = 31 * hashCode + (this.getOnPremisesTagSet() == null ? 0 : this.getOnPremisesTagSet().hashCode());
        hashCode = 31 * hashCode + (this.getComputePlatform() == null ? 0 : this.getComputePlatform().hashCode());
        hashCode = 31 * hashCode + (this.getEcsServices() == null ? 0 : this.getEcsServices().hashCode());
        hashCode = 31 * hashCode + (this.getTerminationHookEnabled() == null ? 0 : this.getTerminationHookEnabled().hashCode());
        return hashCode;
    }

    public DeploymentGroupInfo clone() {
        try {
            return (DeploymentGroupInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentGroupInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

