/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codedeploy.model.InstanceSummary;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class InstanceSummaryMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> LIFECYCLEEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lifecycleEvents").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceType").build();
    private static final InstanceSummaryMarshaller instance = new InstanceSummaryMarshaller();

    public static InstanceSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceSummary instanceSummary, ProtocolMarshaller protocolMarshaller) {
        if (instanceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceSummary.getDeploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)instanceSummary.getInstanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instanceSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceSummary.getLastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(instanceSummary.getLifecycleEvents(), LIFECYCLEEVENTS_BINDING);
            protocolMarshaller.marshall((Object)instanceSummary.getInstanceType(), INSTANCETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

