/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.Commit;
import com.amazonaws.services.codecommit.model.transform.UserInfoJsonMarshaller;
import java.util.List;

public class CommitJsonMarshaller {
    private static CommitJsonMarshaller instance;

    public void marshall(Commit commit, StructuredJsonGenerator jsonGenerator) {
        if (commit == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> parentsList;
            jsonGenerator.writeStartObject();
            if (commit.getTreeId() != null) {
                jsonGenerator.writeFieldName("treeId").writeValue(commit.getTreeId());
            }
            if ((parentsList = commit.getParents()) != null) {
                jsonGenerator.writeFieldName("parents");
                jsonGenerator.writeStartArray();
                for (String parentsListValue : parentsList) {
                    if (parentsListValue == null) continue;
                    jsonGenerator.writeValue(parentsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (commit.getMessage() != null) {
                jsonGenerator.writeFieldName("message").writeValue(commit.getMessage());
            }
            if (commit.getAuthor() != null) {
                jsonGenerator.writeFieldName("author");
                UserInfoJsonMarshaller.getInstance().marshall(commit.getAuthor(), jsonGenerator);
            }
            if (commit.getCommitter() != null) {
                jsonGenerator.writeFieldName("committer");
                UserInfoJsonMarshaller.getInstance().marshall(commit.getCommitter(), jsonGenerator);
            }
            if (commit.getAdditionalData() != null) {
                jsonGenerator.writeFieldName("additionalData").writeValue(commit.getAdditionalData());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommitJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommitJsonMarshaller();
        }
        return instance;
    }
}

