/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codecommit.AWSCodeCommit;
import com.amazonaws.services.codecommit.model.AWSCodeCommitException;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesRequest;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesResult;
import com.amazonaws.services.codecommit.model.BlobIdDoesNotExistException;
import com.amazonaws.services.codecommit.model.BlobIdRequiredException;
import com.amazonaws.services.codecommit.model.BranchDoesNotExistException;
import com.amazonaws.services.codecommit.model.BranchNameExistsException;
import com.amazonaws.services.codecommit.model.BranchNameRequiredException;
import com.amazonaws.services.codecommit.model.CommitDoesNotExistException;
import com.amazonaws.services.codecommit.model.CommitIdDoesNotExistException;
import com.amazonaws.services.codecommit.model.CommitIdRequiredException;
import com.amazonaws.services.codecommit.model.CommitRequiredException;
import com.amazonaws.services.codecommit.model.CreateBranchRequest;
import com.amazonaws.services.codecommit.model.CreateBranchResult;
import com.amazonaws.services.codecommit.model.CreateRepositoryRequest;
import com.amazonaws.services.codecommit.model.CreateRepositoryResult;
import com.amazonaws.services.codecommit.model.DeleteRepositoryRequest;
import com.amazonaws.services.codecommit.model.DeleteRepositoryResult;
import com.amazonaws.services.codecommit.model.EncryptionIntegrityChecksFailedException;
import com.amazonaws.services.codecommit.model.EncryptionKeyAccessDeniedException;
import com.amazonaws.services.codecommit.model.EncryptionKeyDisabledException;
import com.amazonaws.services.codecommit.model.EncryptionKeyNotFoundException;
import com.amazonaws.services.codecommit.model.EncryptionKeyUnavailableException;
import com.amazonaws.services.codecommit.model.FileTooLargeException;
import com.amazonaws.services.codecommit.model.GetBlobRequest;
import com.amazonaws.services.codecommit.model.GetBlobResult;
import com.amazonaws.services.codecommit.model.GetBranchRequest;
import com.amazonaws.services.codecommit.model.GetBranchResult;
import com.amazonaws.services.codecommit.model.GetCommitRequest;
import com.amazonaws.services.codecommit.model.GetCommitResult;
import com.amazonaws.services.codecommit.model.GetDifferencesRequest;
import com.amazonaws.services.codecommit.model.GetDifferencesResult;
import com.amazonaws.services.codecommit.model.GetRepositoryRequest;
import com.amazonaws.services.codecommit.model.GetRepositoryResult;
import com.amazonaws.services.codecommit.model.GetRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.GetRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.InvalidBlobIdException;
import com.amazonaws.services.codecommit.model.InvalidBranchNameException;
import com.amazonaws.services.codecommit.model.InvalidCommitException;
import com.amazonaws.services.codecommit.model.InvalidCommitIdException;
import com.amazonaws.services.codecommit.model.InvalidContinuationTokenException;
import com.amazonaws.services.codecommit.model.InvalidMaxResultsException;
import com.amazonaws.services.codecommit.model.InvalidOrderException;
import com.amazonaws.services.codecommit.model.InvalidPathException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryDescriptionException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryNameException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerBranchNameException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerCustomDataException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerDestinationArnException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerEventsException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerNameException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerRegionException;
import com.amazonaws.services.codecommit.model.InvalidSortByException;
import com.amazonaws.services.codecommit.model.ListBranchesRequest;
import com.amazonaws.services.codecommit.model.ListBranchesResult;
import com.amazonaws.services.codecommit.model.ListRepositoriesRequest;
import com.amazonaws.services.codecommit.model.ListRepositoriesResult;
import com.amazonaws.services.codecommit.model.MaximumBranchesExceededException;
import com.amazonaws.services.codecommit.model.MaximumRepositoryNamesExceededException;
import com.amazonaws.services.codecommit.model.MaximumRepositoryTriggersExceededException;
import com.amazonaws.services.codecommit.model.PathDoesNotExistException;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.RepositoryDoesNotExistException;
import com.amazonaws.services.codecommit.model.RepositoryLimitExceededException;
import com.amazonaws.services.codecommit.model.RepositoryNameExistsException;
import com.amazonaws.services.codecommit.model.RepositoryNameRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryNamesRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggerBranchNameListRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggerDestinationArnRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggerEventsListRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggerNameRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggersListRequiredException;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.UpdateDefaultBranchRequest;
import com.amazonaws.services.codecommit.model.UpdateDefaultBranchResult;
import com.amazonaws.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryDescriptionResult;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameResult;
import com.amazonaws.services.codecommit.model.transform.BatchGetRepositoriesRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.BatchGetRepositoriesResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.CreateBranchRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.CreateBranchResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.CreateRepositoryRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.CreateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.DeleteRepositoryRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.DeleteRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetBlobRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetBlobResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetBranchRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetBranchResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetCommitRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetCommitResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetDifferencesRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetDifferencesResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetRepositoryRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetRepositoryTriggersRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetRepositoryTriggersResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.ListBranchesRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.ListBranchesResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.ListRepositoriesRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.ListRepositoriesResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.PutRepositoryTriggersRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.PutRepositoryTriggersResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.TestRepositoryTriggersRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.TestRepositoryTriggersResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.UpdateDefaultBranchRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.UpdateDefaultBranchResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.UpdateRepositoryDescriptionRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.UpdateRepositoryDescriptionResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.UpdateRepositoryNameRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.UpdateRepositoryNameResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCodeCommitClient
extends AmazonWebServiceClient
implements AWSCodeCommit {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCodeCommit.class);
    private static final String DEFAULT_SIGNING_NAME = "codecommit";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryLimitExceededException").withModeledClass(RepositoryLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EncryptionKeyDisabledException").withModeledClass(EncryptionKeyDisabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CommitIdRequiredException").withModeledClass(CommitIdRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EncryptionKeyNotFoundException").withModeledClass(EncryptionKeyNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPathException").withModeledClass(InvalidPathException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCommitException").withModeledClass(InvalidCommitException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidBlobIdException").withModeledClass(InvalidBlobIdException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRepositoryDescriptionException").withModeledClass(InvalidRepositoryDescriptionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileTooLargeException").withModeledClass(FileTooLargeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRepositoryTriggerDestinationArnException").withModeledClass(InvalidRepositoryTriggerDestinationArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaximumRepositoryTriggersExceededException").withModeledClass(MaximumRepositoryTriggersExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRepositoryTriggerBranchNameException").withModeledClass(InvalidRepositoryTriggerBranchNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BlobIdRequiredException").withModeledClass(BlobIdRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSortByException").withModeledClass(InvalidSortByException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BlobIdDoesNotExistException").withModeledClass(BlobIdDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNamesRequiredException").withModeledClass(RepositoryNamesRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EncryptionKeyAccessDeniedException").withModeledClass(EncryptionKeyAccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNameRequiredException").withModeledClass(RepositoryNameRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRepositoryTriggerRegionException").withModeledClass(InvalidRepositoryTriggerRegionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryTriggerDestinationArnRequiredException").withModeledClass(RepositoryTriggerDestinationArnRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNameExistsException").withModeledClass(RepositoryNameExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PathDoesNotExistException").withModeledClass(PathDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidMaxResultsException").withModeledClass(InvalidMaxResultsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BranchNameExistsException").withModeledClass(BranchNameExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryTriggersListRequiredException").withModeledClass(RepositoryTriggersListRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BranchDoesNotExistException").withModeledClass(BranchDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EncryptionIntegrityChecksFailedException").withModeledClass(EncryptionIntegrityChecksFailedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryTriggerEventsListRequiredException").withModeledClass(RepositoryTriggerEventsListRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCommitIdException").withModeledClass(InvalidCommitIdException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidOrderException").withModeledClass(InvalidOrderException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CommitDoesNotExistException").withModeledClass(CommitDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryTriggerBranchNameListRequiredException").withModeledClass(RepositoryTriggerBranchNameListRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRepositoryTriggerCustomDataException").withModeledClass(InvalidRepositoryTriggerCustomDataException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRepositoryTriggerEventsException").withModeledClass(InvalidRepositoryTriggerEventsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BranchNameRequiredException").withModeledClass(BranchNameRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryTriggerNameRequiredException").withModeledClass(RepositoryTriggerNameRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRepositoryTriggerNameException").withModeledClass(InvalidRepositoryTriggerNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CommitIdDoesNotExistException").withModeledClass(CommitIdDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EncryptionKeyUnavailableException").withModeledClass(EncryptionKeyUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaximumRepositoryNamesExceededException").withModeledClass(MaximumRepositoryNamesExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRepositoryNameException").withModeledClass(InvalidRepositoryNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryDoesNotExistException").withModeledClass(RepositoryDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidContinuationTokenException").withModeledClass(InvalidContinuationTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CommitRequiredException").withModeledClass(CommitRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaximumBranchesExceededException").withModeledClass(MaximumBranchesExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidBranchNameException").withModeledClass(InvalidBranchNameException.class)).withBaseServiceExceptionClass(AWSCodeCommitException.class));

    @Deprecated
    public AWSCodeCommitClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSCodeCommitClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSCodeCommitClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSCodeCommitClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSCodeCommitClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSCodeCommitClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSCodeCommitClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AWSCodeCommitClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://codecommit.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codecommit/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codecommit/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetRepositoriesResult batchGetRepositories(BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetRepositoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetRepositoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetRepositoriesRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((BatchGetRepositoriesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetRepositoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetRepositoriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetRepositoriesResult batchGetRepositoriesResult = (BatchGetRepositoriesResult)response.getAwsResponse();
            return batchGetRepositoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBranchResult createBranch(CreateBranchRequest createBranchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBranchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBranchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBranchRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((CreateBranchRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBranchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBranchResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBranchResult createBranchResult = (CreateBranchResult)response.getAwsResponse();
            return createBranchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRepositoryResult createRepository(CreateRepositoryRequest createRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRepositoryRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((CreateRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRepositoryResult createRepositoryResult = (CreateRepositoryResult)response.getAwsResponse();
            return createRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRepositoryResult deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DeleteRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRepositoryResult deleteRepositoryResult = (DeleteRepositoryResult)response.getAwsResponse();
            return deleteRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBlobResult getBlob(GetBlobRequest getBlobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBlobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBlobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBlobRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetBlobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBlobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBlobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBlobResult getBlobResult = (GetBlobResult)response.getAwsResponse();
            return getBlobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBranchResult getBranch(GetBranchRequest getBranchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBranchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBranchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBranchRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetBranchRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBranchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBranchResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBranchResult getBranchResult = (GetBranchResult)response.getAwsResponse();
            return getBranchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCommitResult getCommit(GetCommitRequest getCommitRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCommitRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCommitRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCommitRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetCommitRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCommitRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCommitResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCommitResult getCommitResult = (GetCommitResult)response.getAwsResponse();
            return getCommitResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDifferencesResult getDifferences(GetDifferencesRequest getDifferencesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDifferencesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDifferencesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDifferencesRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetDifferencesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDifferencesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDifferencesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDifferencesResult getDifferencesResult = (GetDifferencesResult)response.getAwsResponse();
            return getDifferencesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositoryResult getRepository(GetRepositoryRequest getRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRepositoryRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRepositoryResult getRepositoryResult = (GetRepositoryResult)response.getAwsResponse();
            return getRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositoryTriggersResult getRepositoryTriggers(GetRepositoryTriggersRequest getRepositoryTriggersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRepositoryTriggersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRepositoryTriggersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRepositoryTriggersRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetRepositoryTriggersRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRepositoryTriggersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRepositoryTriggersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRepositoryTriggersResult getRepositoryTriggersResult = (GetRepositoryTriggersResult)response.getAwsResponse();
            return getRepositoryTriggersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBranchesResult listBranches(ListBranchesRequest listBranchesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBranchesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBranchesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBranchesRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ListBranchesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listBranchesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBranchesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBranchesResult listBranchesResult = (ListBranchesResult)response.getAwsResponse();
            return listBranchesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRepositoriesResult listRepositories(ListRepositoriesRequest listRepositoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRepositoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRepositoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRepositoriesRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ListRepositoriesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRepositoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRepositoriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRepositoriesResult listRepositoriesResult = (ListRepositoriesResult)response.getAwsResponse();
            return listRepositoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRepositoryTriggersResult putRepositoryTriggers(PutRepositoryTriggersRequest putRepositoryTriggersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRepositoryTriggersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRepositoryTriggersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRepositoryTriggersRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((PutRepositoryTriggersRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRepositoryTriggersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRepositoryTriggersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRepositoryTriggersResult putRepositoryTriggersResult = (PutRepositoryTriggersResult)response.getAwsResponse();
            return putRepositoryTriggersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestRepositoryTriggersResult testRepositoryTriggers(TestRepositoryTriggersRequest testRepositoryTriggersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testRepositoryTriggersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestRepositoryTriggersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestRepositoryTriggersRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((TestRepositoryTriggersRequest)super.beforeMarshalling((AmazonWebServiceRequest)testRepositoryTriggersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TestRepositoryTriggersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TestRepositoryTriggersResult testRepositoryTriggersResult = (TestRepositoryTriggersResult)response.getAwsResponse();
            return testRepositoryTriggersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDefaultBranchResult updateDefaultBranch(UpdateDefaultBranchRequest updateDefaultBranchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDefaultBranchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDefaultBranchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDefaultBranchRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateDefaultBranchRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDefaultBranchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDefaultBranchResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDefaultBranchResult updateDefaultBranchResult = (UpdateDefaultBranchResult)response.getAwsResponse();
            return updateDefaultBranchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRepositoryDescriptionResult updateRepositoryDescription(UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRepositoryDescriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRepositoryDescriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRepositoryDescriptionRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateRepositoryDescriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRepositoryDescriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRepositoryDescriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRepositoryDescriptionResult updateRepositoryDescriptionResult = (UpdateRepositoryDescriptionResult)response.getAwsResponse();
            return updateRepositoryDescriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRepositoryNameResult updateRepositoryName(UpdateRepositoryNameRequest updateRepositoryNameRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRepositoryNameRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRepositoryNameRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRepositoryNameRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateRepositoryNameRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRepositoryNameRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRepositoryNameResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRepositoryNameResult updateRepositoryNameResult = (UpdateRepositoryNameResult)response.getAwsResponse();
            return updateRepositoryNameResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

