/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.metrics.internal.cloudwatch.BlockingRequestBuilder;
import com.amazonaws.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.ValidationUtils;
import com.amazonaws.util.VersionInfoUtils;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
class MetricUploaderThread
extends Thread {
    private static final String USER_AGENT = MetricUploaderThread.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String THREAD_NAME = "java-sdk-metric-uploader";
    private volatile boolean cancelled;
    private final AmazonCloudWatch cloudwatchClient;
    private final Log log = LogFactory.getLog(this.getClass());
    private final BlockingRequestBuilder qIterator;

    MetricUploaderThread(CloudWatchMetricConfig config, BlockingQueue<MetricDatum> queue) {
        this(config, queue, MetricUploaderThread.createCloudWatchClient(config));
    }

    private static AmazonCloudWatch createCloudWatchClient(CloudWatchMetricConfig config) {
        if (config.getCloudWatchEndPoint() != null && config.getEndpointConfiguration() != null) {
            throw new IllegalArgumentException("Both cloudWatchEndpoint and endpointConfiguration are specified and only one should be specified (cloudWatchEndpoint is deprecated in favor of endpointConfiguration)");
        }
        AmazonCloudWatchClientBuilder amazonCloudWatchClientBuilder = AmazonCloudWatchClient.builder();
        amazonCloudWatchClientBuilder.withClientConfiguration(config.getClientConfiguration());
        amazonCloudWatchClientBuilder.withCredentials(config.getCredentialsProvider());
        amazonCloudWatchClientBuilder.withEndpointConfiguration(config.getEndpointConfiguration());
        if (config.getCloudWatchEndPoint() != null) {
            String cloudWatchEndPoint = config.getCloudWatchEndPoint();
            String region = AwsHostNameUtils.parseRegion((String)cloudWatchEndPoint, (String)"monitoring");
            amazonCloudWatchClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(cloudWatchEndPoint, region));
        }
        return (AmazonCloudWatch)amazonCloudWatchClientBuilder.build();
    }

    @SdkTestInternalApi
    MetricUploaderThread(CloudWatchMetricConfig config, BlockingQueue<MetricDatum> queue, AmazonCloudWatch client) {
        super(THREAD_NAME);
        ValidationUtils.assertNotNull((Object)config, (String)"config");
        ValidationUtils.assertNotNull(queue, (String)"queue");
        this.cloudwatchClient = client;
        this.qIterator = new BlockingRequestBuilder(config, queue);
        this.setPriority(1);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.cancelled) {
            try {
                Iterable<PutMetricDataRequest> requests = this.qIterator.nextUploadUnits();
                for (PutMetricDataRequest req : requests) {
                    this.appendUserAgent(req);
                    this.log.debug((Object)req);
                    this.cloudwatchClient.putMetricData(req);
                    Thread.yield();
                }
            }
            catch (InterruptedException e) {
                if (this.cancelled) continue;
                this.log.debug((Object)"Unexpected interruption ignored");
            }
            catch (Throwable t) {
                this.log.warn((Object)"Unexpected condition; soldier on", t);
                Thread.yield();
            }
        }
    }

    void cancel() {
        this.cancelled = true;
    }

    AmazonCloudWatchClient getCloudwatchClient() {
        return (AmazonCloudWatchClient)this.cloudwatchClient;
    }

    private void appendUserAgent(PutMetricDataRequest request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
    }
}

