/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatchevidently.model.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutProjectEventsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<Event> events;
    private String project;

    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<Event> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new ArrayList<Event>(events);
    }

    public PutProjectEventsRequest withEvents(Event ... events) {
        if (this.events == null) {
            this.setEvents(new ArrayList<Event>(events.length));
        }
        for (Event ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public PutProjectEventsRequest withEvents(Collection<Event> events) {
        this.setEvents(events);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public PutProjectEventsRequest withProject(String project) {
        this.setProject(project);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProjectEventsRequest)) {
            return false;
        }
        PutProjectEventsRequest other = (PutProjectEventsRequest)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        return other.getProject() == null || other.getProject().equals(this.getProject());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        return hashCode;
    }

    public PutProjectEventsRequest clone() {
        return (PutProjectEventsRequest)super.clone();
    }
}

