/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudsearchdomain.model.FieldStats;

public class FieldStatsJsonMarshaller {
    private static FieldStatsJsonMarshaller instance;

    public void marshall(FieldStats fieldStats, StructuredJsonGenerator jsonGenerator) {
        if (fieldStats == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (fieldStats.getMin() != null) {
                jsonGenerator.writeFieldName("min").writeValue(fieldStats.getMin());
            }
            if (fieldStats.getMax() != null) {
                jsonGenerator.writeFieldName("max").writeValue(fieldStats.getMax());
            }
            if (fieldStats.getCount() != null) {
                jsonGenerator.writeFieldName("count").writeValue(fieldStats.getCount().longValue());
            }
            if (fieldStats.getMissing() != null) {
                jsonGenerator.writeFieldName("missing").writeValue(fieldStats.getMissing().longValue());
            }
            if (fieldStats.getSum() != null) {
                jsonGenerator.writeFieldName("sum").writeValue(fieldStats.getSum().doubleValue());
            }
            if (fieldStats.getSumOfSquares() != null) {
                jsonGenerator.writeFieldName("sumOfSquares").writeValue(fieldStats.getSumOfSquares().doubleValue());
            }
            if (fieldStats.getMean() != null) {
                jsonGenerator.writeFieldName("mean").writeValue(fieldStats.getMean());
            }
            if (fieldStats.getStddev() != null) {
                jsonGenerator.writeFieldName("stddev").writeValue(fieldStats.getStddev().doubleValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FieldStatsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FieldStatsJsonMarshaller();
        }
        return instance;
    }
}

