/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.PublicKeyList;
import com.amazonaws.services.cloudfront.model.PublicKeySummary;
import com.amazonaws.services.cloudfront.model.transform.PublicKeySummaryStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class PublicKeyListStaxUnmarshaller
implements Unmarshaller<PublicKeyList, StaxUnmarshallerContext> {
    private static PublicKeyListStaxUnmarshaller instance;

    public PublicKeyList unmarshall(StaxUnmarshallerContext context) throws Exception {
        PublicKeyList publicKeyList = new PublicKeyList();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return publicKeyList;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NextMarker", targetDepth)) {
                    publicKeyList.setNextMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxItems", targetDepth)) {
                    publicKeyList.setMaxItems(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    publicKeyList.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    publicKeyList.withItems(new ArrayList<PublicKeySummary>());
                    continue;
                }
                if (!context.testExpression("Items/PublicKeySummary", targetDepth)) continue;
                publicKeyList.withItems(PublicKeySummaryStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return publicKeyList;
    }

    public static PublicKeyListStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PublicKeyListStaxUnmarshaller();
        }
        return instance;
    }
}

