/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.OriginAccessControlList;
import com.amazonaws.services.cloudfront.model.OriginAccessControlSummary;
import com.amazonaws.services.cloudfront.model.transform.OriginAccessControlSummaryStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class OriginAccessControlListStaxUnmarshaller
implements Unmarshaller<OriginAccessControlList, StaxUnmarshallerContext> {
    private static OriginAccessControlListStaxUnmarshaller instance;

    public OriginAccessControlList unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginAccessControlList originAccessControlList = new OriginAccessControlList();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return originAccessControlList;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Marker", targetDepth)) {
                    originAccessControlList.setMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NextMarker", targetDepth)) {
                    originAccessControlList.setNextMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxItems", targetDepth)) {
                    originAccessControlList.setMaxItems(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsTruncated", targetDepth)) {
                    originAccessControlList.setIsTruncated(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    originAccessControlList.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    originAccessControlList.withItems(new ArrayList<OriginAccessControlSummary>());
                    continue;
                }
                if (!context.testExpression("Items/OriginAccessControlSummary", targetDepth)) continue;
                originAccessControlList.withItems(OriginAccessControlSummaryStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return originAccessControlList;
    }

    public static OriginAccessControlListStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginAccessControlListStaxUnmarshaller();
        }
        return instance;
    }
}

